/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.apache.avro.util.Utf8;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.avrogen.motion.JointDefinitionRecord;

public class PortableJointDefinition
implements RobotDefinitionResponse.JointDefinition {
    private JointDefinitionRecord myRecord;
    private Joint.Id myCachedId;
    private NormalizedDouble myCachedDefaultPosition;
    private NormalizedDouble myCachedGoalPosition;

    public PortableJointDefinition(JointDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.setRecord(record);
    }

    public PortableJointDefinition(RobotDefinitionResponse.JointDefinition jointDef) {
        if (jointDef == null) {
            throw new NullPointerException();
        }
        if (jointDef instanceof PortableJointDefinition) {
            PortableJointDefinition pr = (PortableJointDefinition)jointDef;
            this.setRecord(pr.getRecord());
            return;
        }
        this.setRecord(jointDef.getJointId(), jointDef.getName().toString(), jointDef.getDefaultPosition(), jointDef.getGoalPosition(), jointDef.getEnabled());
    }

    public PortableJointDefinition(Joint.Id jId, String name, NormalizedDouble defPos, NormalizedDouble goalPos, boolean enabled) {
        this.setRecord(jId, name, defPos, goalPos, enabled);
    }

    public PortableJointDefinition(Joint joint) {
        this.setRecord(joint.getId(), joint.getName(), joint.getDefaultPosition(), joint.getGoalPosition(), joint.getEnabled());
    }

    private void setRecord(Joint.Id jId, String name, NormalizedDouble defPos, NormalizedDouble goalPos, boolean enabled) {
        JointDefinitionRecord rec = new JointDefinitionRecord();
        rec.jointId = jId.getLogicalJointNumber();
        rec.name = new Utf8(name);
        rec.defaultPosition = defPos.getValue();
        rec.goalPosition = goalPos.getValue();
        rec.enabled = enabled;
        this.myCachedId = jId;
        this.myCachedDefaultPosition = defPos;
        this.myCachedGoalPosition = goalPos;
        this.myRecord = rec;
    }

    private void setRecord(JointDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Joint.Id(this.myRecord.jointId);
        this.myCachedDefaultPosition = new NormalizedDouble(this.myRecord.defaultPosition);
        this.myCachedGoalPosition = new NormalizedDouble(this.myRecord.goalPosition);
    }

    public Joint.Id getJointId() {
        return this.myCachedId;
    }

    public String getName() {
        return this.myRecord.name.toString();
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myCachedDefaultPosition;
    }

    public NormalizedDouble getGoalPosition() {
        return this.myCachedGoalPosition;
    }

    public boolean getEnabled() {
        return this.myRecord.enabled;
    }

    public JointDefinitionRecord getRecord() {
        return this.myRecord;
    }
}

