/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.avrogen.motion.JointPropDefinitionRecord;
import org.robokind.impl.motion.messaging.PortableJointDefinition;

public class PortableJointPropDefinition
implements RobotDefinitionResponse.JointPropDefinition {
    private JointPropDefinitionRecord myRecord;

    public PortableJointPropDefinition(JointPropDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableJointPropDefinition(RobotDefinitionResponse.JointPropDefinition def) {
        if (def == null) {
            throw new NullPointerException();
        }
        if (def instanceof PortableJointDefinition) {
            PortableJointPropDefinition pr = (PortableJointPropDefinition)def;
            this.myRecord = pr.getRecord();
            return;
        }
        this.setRecord(def.getPropertyName(), def.getDisplayName(), def.getMinValue(), def.getMaxValue(), def.getInitialValue());
    }

    public PortableJointPropDefinition(String propName, String displayName, double minVal, double maxVal, double initialVal) {
        this.setRecord(propName, displayName, minVal, maxVal, initialVal);
    }

    public PortableJointPropDefinition(JointProperty prop) {
        Class c = prop.getPropertyClass();
        NormalizableRange r = prop.getNormalizableRange();
        if (!Number.class.isAssignableFrom(c)) {
            this.setRecord(prop.getPropertyName(), prop.getDisplayName(), 0.0, 1.0, r.normalizeValue(prop.getValue()).getValue());
            return;
        }
        Number n = (Number)prop.getValue();
        Number min = (Number)r.getMin();
        Number max = (Number)r.getMax();
        this.setRecord(prop.getPropertyName(), prop.getDisplayName(), min.doubleValue(), max.doubleValue(), n.doubleValue());
    }

    private void setRecord(String propName, String displayName, double minVal, double maxVal, double initialVal) {
        JointPropDefinitionRecord rec = new JointPropDefinitionRecord();
        rec.propertyName = new Utf8(propName);
        rec.displayName = new Utf8(displayName);
        rec.minValue = minVal;
        rec.maxValue = maxVal;
        rec.initialValue = initialVal;
        this.myRecord = rec;
    }

    public String getPropertyName() {
        return this.myRecord.propertyName.toString();
    }

    public String getDisplayName() {
        return this.myRecord.displayName.toString();
    }

    public Double getMinValue() {
        return this.myRecord.minValue;
    }

    public Double getMaxValue() {
        return this.myRecord.maxValue;
    }

    public Double getInitialValue() {
        return this.myRecord.initialValue;
    }

    public JointPropDefinitionRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<JointPropDefinitionRecord, RobotDefinitionResponse.JointPropDefinition> {
        public RobotDefinitionResponse.JointPropDefinition adapt(JointPropDefinitionRecord a) {
            return new PortableJointPropDefinition(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<RobotDefinitionResponse.JointPropDefinition, JointPropDefinitionRecord> {
        public JointPropDefinitionRecord adapt(RobotDefinitionResponse.JointPropDefinition a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableJointPropDefinition(a).getRecord();
        }
    }
}

