/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.avrogen.motion.MotionFrameEventRecord;
import org.robokind.avrogen.motion.MotionFrameRecord;
import org.robokind.impl.motion.messaging.MotionMessagingUtils;

public class PortableMotionFrameEvent
implements MotionFrameEvent {
    private MotionFrameEventRecord myFrameEventRecord;
    private MotionFrame<Robot.RobotPositionMap> myCachedMotionFrame;

    public PortableMotionFrameEvent(MotionFrameEventRecord frameEventRec) {
        if (frameEventRec == null) {
            throw new NullPointerException();
        }
        this.myFrameEventRecord = frameEventRec;
    }

    public PortableMotionFrameEvent(String sourceId, String destinationId, long currentTimeMillisecUTC, MotionFrame<Robot.RobotPositionMap> motionFrame) {
        if (sourceId == null || destinationId == null || motionFrame == null) {
            throw new NullPointerException();
        }
        this.myFrameEventRecord = new MotionFrameEventRecord();
        this.myFrameEventRecord.sourceId = new Utf8(sourceId);
        this.myFrameEventRecord.destinationId = new Utf8(destinationId);
        this.myFrameEventRecord.currentTimeMillisecUTC = currentTimeMillisecUTC;
        this.myFrameEventRecord.motionFrame = MotionMessagingUtils.packMotionFrame(motionFrame);
        this.myCachedMotionFrame = motionFrame;
    }

    public PortableMotionFrameEvent(MotionFrameEvent frameEvent) {
        if (frameEvent == null) {
            throw new NullPointerException();
        }
        if (frameEvent instanceof PortableMotionFrameEvent) {
            this.myFrameEventRecord = ((PortableMotionFrameEvent)frameEvent).myFrameEventRecord;
            this.myCachedMotionFrame = ((PortableMotionFrameEvent)frameEvent).myCachedMotionFrame;
            return;
        }
        this.myFrameEventRecord = new MotionFrameEventRecord();
        this.myFrameEventRecord.sourceId = new Utf8(frameEvent.getSourceId());
        this.myFrameEventRecord.destinationId = new Utf8(frameEvent.getDestinationId());
        this.myFrameEventRecord.currentTimeMillisecUTC = frameEvent.getTimestampMillisecUTC();
        this.myFrameEventRecord.motionFrame = MotionMessagingUtils.packMotionFrame((MotionFrame<Robot.RobotPositionMap>)frameEvent.getMotionFrame());
        this.myCachedMotionFrame = frameEvent.getMotionFrame();
    }

    public String getSourceId() {
        if (this.myFrameEventRecord.sourceId == null) {
            return null;
        }
        return this.myFrameEventRecord.sourceId.toString();
    }

    public String getDestinationId() {
        if (this.myFrameEventRecord.destinationId == null) {
            return null;
        }
        return this.myFrameEventRecord.destinationId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myFrameEventRecord.currentTimeMillisecUTC;
    }

    public MotionFrame<Robot.RobotPositionMap> getMotionFrame() {
        if (this.myCachedMotionFrame == null) {
            MotionFrameRecord frameRec = this.myFrameEventRecord.motionFrame;
            this.myCachedMotionFrame = MotionMessagingUtils.unpackMotionFrame(frameRec);
        }
        return this.myCachedMotionFrame;
    }

    public MotionFrameEventRecord getRecord() {
        return this.myFrameEventRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<MotionFrameEventRecord, MotionFrameEvent> {
        public MotionFrameEvent adapt(MotionFrameEventRecord a) {
            return new PortableMotionFrameEvent(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<MotionFrameEvent, MotionFrameEventRecord> {
        public MotionFrameEventRecord adapt(MotionFrameEvent a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableMotionFrameEvent(a).getRecord();
        }
    }

    public static class Factory
    implements MotionFrameEvent.MotionFrameEventFactory {
        public MotionFrameEvent createMotionFrameEvent(String sourceId, String destId, MotionFrame<Robot.RobotPositionMap> motionFrame) {
            return new PortableMotionFrameEvent(sourceId, destId, TimeUtils.now(), motionFrame);
        }
    }
}

