/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.messaging.RobotRequestFactory;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.avrogen.motion.RobotRequestRecord;

public class PortableRobotRequest
implements RobotRequest {
    private RobotRequestRecord myRecord;
    private Robot.Id myCachedId;

    public PortableRobotRequest(RobotRequestRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Robot.Id(this.myRecord.robotId.toString());
    }

    public PortableRobotRequest(RobotRequest request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (request instanceof PortableRobotRequest) {
            this.myRecord = ((PortableRobotRequest)request).getRecord();
            this.myCachedId = new Robot.Id(this.myRecord.robotId.toString());
            return;
        }
        this.myCachedId = request.getRobotId();
        this.myRecord = new RobotRequestRecord();
        this.myRecord.robotId = new Utf8(this.myCachedId.getRobtIdString());
        this.myRecord.requestSourceId = new Utf8(request.getSourceId());
        this.myRecord.requestDestinationId = new Utf8(request.getDestinationId());
        this.myRecord.requestType = new Utf8(request.getRequestType());
        this.myRecord.timestampMillisecUTC = request.getTimestampMillisecUTC();
    }

    public PortableRobotRequest(Robot.Id robotId, String sourceId, String destId, String requestType, long timestampMillisecUTC, Integer requestIndex) {
        this.myCachedId = robotId;
        this.myRecord = new RobotRequestRecord();
        this.myRecord.robotId = new Utf8(this.myCachedId.getRobtIdString());
        this.myRecord.requestSourceId = new Utf8(sourceId);
        this.myRecord.requestDestinationId = new Utf8(destId);
        this.myRecord.requestType = new Utf8(requestType);
        this.myRecord.timestampMillisecUTC = timestampMillisecUTC;
        this.myRecord.intParam = requestIndex;
    }

    public Robot.Id getRobotId() {
        return this.myCachedId;
    }

    public String getSourceId() {
        return this.myRecord.requestSourceId.toString();
    }

    public String getDestinationId() {
        return this.myRecord.requestDestinationId.toString();
    }

    public String getRequestType() {
        return this.myRecord.requestType.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public Integer getRequestIndex() {
        return this.myRecord.intParam;
    }

    public RobotRequestRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<RobotRequestRecord, RobotRequest> {
        public RobotRequest adapt(RobotRequestRecord a) {
            return new PortableRobotRequest(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<RobotRequest, RobotRequestRecord> {
        public RobotRequestRecord adapt(RobotRequest a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableRobotRequest(a).getRecord();
        }
    }

    public static class Factory
    implements RobotRequestFactory<PortableRobotRequest> {
        public PortableRobotRequest buildRobotRequest(Robot.Id robotId, String sourceId, String destId, String requestType, long timestampMillisecUTC) {
            return new PortableRobotRequest(robotId, sourceId, destId, requestType, timestampMillisecUTC, null);
        }

        public PortableRobotRequest buildJointRequest(Robot.JointId jointId, String sourceId, String destId, String requestType, long timestampMillisecUTC) {
            Robot.Id robotId = jointId.getRobotId();
            Integer jointIdInt = jointId.getJointId().getLogicalJointNumber();
            return new PortableRobotRequest(robotId, sourceId, destId, requestType, timestampMillisecUTC, jointIdInt);
        }
    }
}

