/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.sync;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.sync.SynchronizedJointConfig;
import org.robokind.api.motion.sync.SynchronizedRobotConfig;
import org.robokind.avrogen.motion.SynchronizedJointConfigRecord;
import org.robokind.avrogen.motion.SynchronizedRobotConfigRecord;
import org.robokind.impl.motion.sync.PortableSynchronizedJointConfig;

public class PortableSynchronizedRobotConfig
implements SynchronizedRobotConfig {
    private SynchronizedRobotConfigRecord myRecord;
    private Robot.Id myRobotId;
    private List<PortableSynchronizedJointConfig> myCachedJointConfigs;

    public PortableSynchronizedRobotConfig(SynchronizedRobotConfigRecord record) {
        this.setRecord(record);
    }

    public PortableSynchronizedRobotConfig(SynchronizedRobotConfig conf) {
        if (conf == null) {
            throw new NullPointerException();
        }
        if (conf instanceof PortableSynchronizedRobotConfig) {
            this.setRecord(((PortableSynchronizedRobotConfig)conf).getRecord());
            return;
        }
        this.myRecord = new SynchronizedRobotConfigRecord();
        this.myRecord.robotId = new Utf8(conf.getRobotId().getRobtIdString());
        List joints = conf.getJointConfigs();
        this.myRecord.joints = new GenericData.Array(joints.size(), Schema.createArray((Schema)SynchronizedJointConfigRecord.SCHEMA$));
        for (SynchronizedJointConfig jc : joints) {
            this.myRecord.joints.add((Object)new PortableSynchronizedJointConfig(jc).getRecord());
        }
    }

    public PortableSynchronizedRobotConfig(Robot.Id robotId, List<PortableSynchronizedJointConfig> jointConfigs) {
        if (robotId == null || jointConfigs == null) {
            throw new NullPointerException();
        }
        this.myRobotId = robotId;
        this.myCachedJointConfigs = jointConfigs;
        this.myRecord = new SynchronizedRobotConfigRecord();
        this.myRecord.robotId = new Utf8(this.myRobotId.getRobtIdString());
        this.myRecord.joints = new GenericData.Array(this.myCachedJointConfigs.size(), Schema.createArray((Schema)SynchronizedJointConfigRecord.SCHEMA$));
        for (PortableSynchronizedJointConfig jc : this.myCachedJointConfigs) {
            this.myRecord.joints.add((Object)jc.getRecord());
        }
    }

    private void setRecord(SynchronizedRobotConfigRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myRobotId = new Robot.Id(this.myRecord.robotId.toString());
        int count = this.myRecord.joints.size();
        this.myCachedJointConfigs = new ArrayList<PortableSynchronizedJointConfig>(count);
        for (SynchronizedJointConfigRecord jc : this.myRecord.joints) {
            this.myCachedJointConfigs.add(new PortableSynchronizedJointConfig(jc));
        }
    }

    public Robot.Id getRobotId() {
        return this.myRobotId;
    }

    public List<SynchronizedJointConfig> getJointConfigs() {
        return this.myCachedJointConfigs;
    }

    public SynchronizedRobotConfigRecord getRecord() {
        return this.myRecord;
    }
}

