/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.avrogen.motion.JointDefinitionRecord;
import org.robokind.avrogen.motion.JointPropDefinitionRecord;
import org.robokind.impl.motion.messaging.PortableJointPropDefinition;

public class PortableJointDefinition
implements RobotDefinitionResponse.JointDefinition {
    private JointDefinitionRecord myRecord;
    private Joint.Id myCachedId;
    private NormalizedDouble myCachedDefaultPosition;
    private NormalizedDouble myCachedGoalPosition;
    private List<RobotDefinitionResponse.JointPropDefinition> myPropDefs;

    public PortableJointDefinition(JointDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.setRecord(record);
        this.myPropDefs = new ArrayList<RobotDefinitionResponse.JointPropDefinition>(record.properties.size());
        for (JointPropDefinitionRecord prop : record.properties) {
            this.myPropDefs.add(new PortableJointPropDefinition(prop));
        }
    }

    public PortableJointDefinition(RobotDefinitionResponse.JointDefinition jointDef) {
        if (jointDef == null) {
            throw new NullPointerException();
        }
        this.myPropDefs = jointDef.getJointProperties();
        if (jointDef instanceof PortableJointDefinition) {
            PortableJointDefinition pr = (PortableJointDefinition)jointDef;
            this.setRecord(pr.getRecord());
            return;
        }
        this.setRecord(jointDef.getJointId(), jointDef.getName().toString(), jointDef.getDefaultPosition(), jointDef.getGoalPosition(), jointDef.getEnabled(), jointDef.getJointProperties());
    }

    public PortableJointDefinition(Joint.Id jId, String name, NormalizedDouble defPos, NormalizedDouble goalPos, boolean enabled, List<JointProperty> properties) {
        this.myPropDefs = new ArrayList<RobotDefinitionResponse.JointPropDefinition>(properties.size());
        for (JointProperty prop : properties) {
            PortableJointPropDefinition def = new PortableJointPropDefinition(prop);
            this.myPropDefs.add(def);
        }
        this.setRecord(jId, name, defPos, goalPos, enabled, this.myPropDefs);
    }

    public PortableJointDefinition(Joint joint) {
        this.myPropDefs = new ArrayList<RobotDefinitionResponse.JointPropDefinition>(joint.getProperties().size());
        for (JointProperty prop : joint.getProperties()) {
            PortableJointPropDefinition def = new PortableJointPropDefinition(prop);
            this.myPropDefs.add(def);
        }
        this.setRecord(joint.getId(), joint.getName(), joint.getDefaultPosition(), joint.getGoalPosition(), joint.getEnabled(), this.myPropDefs);
    }

    private void setRecord(Joint.Id jId, String name, NormalizedDouble defPos, NormalizedDouble goalPos, boolean enabled, List<RobotDefinitionResponse.JointPropDefinition> properties) {
        JointDefinitionRecord rec = new JointDefinitionRecord();
        rec.jointId = jId.getLogicalJointNumber();
        rec.name = new Utf8(name);
        rec.defaultPosition = defPos.getValue();
        rec.goalPosition = goalPos.getValue();
        rec.enabled = enabled;
        rec.properties = new GenericData.Array(properties.size(), Schema.createArray((Schema)JointPropDefinitionRecord.SCHEMA$));
        this.myPropDefs = properties;
        for (RobotDefinitionResponse.JointPropDefinition prop : properties) {
            rec.properties.add((Object)new PortableJointPropDefinition(prop).getRecord());
        }
        this.myCachedId = jId;
        this.myCachedDefaultPosition = defPos;
        this.myCachedGoalPosition = goalPos;
        this.myRecord = rec;
    }

    private void setRecord(JointDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Joint.Id(this.myRecord.jointId);
        this.myCachedDefaultPosition = new NormalizedDouble(this.myRecord.defaultPosition);
        this.myCachedGoalPosition = new NormalizedDouble(this.myRecord.goalPosition);
    }

    public Joint.Id getJointId() {
        return this.myCachedId;
    }

    public String getName() {
        return this.myRecord.name.toString();
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myCachedDefaultPosition;
    }

    public NormalizedDouble getGoalPosition() {
        return this.myCachedGoalPosition;
    }

    public boolean getEnabled() {
        return this.myRecord.enabled;
    }

    public List<RobotDefinitionResponse.JointPropDefinition> getJointProperties() {
        return this.myPropDefs;
    }

    public JointDefinitionRecord getRecord() {
        return this.myRecord;
    }
}

