/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.sync;

import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.sync.SynchronizedJointConfig;
import org.robokind.avrogen.motion.SynchronizedJointConfigRecord;

public class PortableSynchronizedJointConfig
implements SynchronizedJointConfig {
    private SynchronizedJointConfigRecord myRecord;
    private Joint.Id myCachedId;
    private NormalizedDouble myCachedDefPos;

    public PortableSynchronizedJointConfig(SynchronizedJointConfigRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.setRecord(record);
    }

    public PortableSynchronizedJointConfig(SynchronizedJointConfig conf) {
        if (conf == null) {
            throw new NullPointerException();
        }
        if (conf instanceof PortableSynchronizedJointConfig) {
            this.setRecord(((PortableSynchronizedJointConfig)conf).getRecord());
            return;
        }
        this.myRecord = new SynchronizedJointConfigRecord();
        this.myRecord.setJointId(Integer.valueOf(conf.getJointId().getLogicalJointNumber()));
        this.myRecord.setName(conf.getName());
        NormalizedDouble def = conf.getDefaultPosition();
        if (def != null) {
            this.myRecord.setDefaultPosition(Double.valueOf(def.getValue()));
        }
        this.setRecord(this.myRecord);
    }

    public PortableSynchronizedJointConfig(Joint.Id jointId, String name, NormalizedDouble defPos) {
        if (jointId == null || name == null) {
            throw new NullPointerException();
        }
        this.myCachedId = jointId;
        this.myCachedDefPos = defPos;
        this.myRecord = new SynchronizedJointConfigRecord();
        this.myRecord.setJointId(Integer.valueOf(this.myCachedId.getLogicalJointNumber()));
        this.myRecord.setName(name);
        if (this.myCachedDefPos != null) {
            this.myRecord.setDefaultPosition(Double.valueOf(this.myCachedDefPos.getValue()));
        }
    }

    private void setRecord(SynchronizedJointConfigRecord record) {
        this.myRecord = record;
        this.myCachedId = new Joint.Id(this.myRecord.getJointId().intValue());
        Double def = this.myRecord.getDefaultPosition();
        if (def != null) {
            this.myCachedDefPos = new NormalizedDouble(def.doubleValue());
        }
    }

    public Joint.Id getJointId() {
        return this.myCachedId;
    }

    public String getName() {
        return this.myRecord.getName();
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myCachedDefPos;
    }

    public SynchronizedJointConfigRecord getRecord() {
        return this.myRecord;
    }
}

