/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.JointProperty;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.avrogen.motion.JointDefinitionRecord;
import org.robokind.avrogen.motion.JointPropDefinitionRecord;

public class PortableJointDefinition
implements RobotDefinitionResponse.JointDefinition {
    private JointDefinitionRecord myRecord;
    private Joint.Id myCachedId;
    private NormalizedDouble myCachedDefaultPosition;
    private NormalizedDouble myCachedGoalPosition;
    private List<RobotDefinitionResponse.JointPropDefinition> myPropDefs;

    public PortableJointDefinition(JointDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.setRecord(record);
        this.myPropDefs = new ArrayList<RobotDefinitionResponse.JointPropDefinition>(record.getProperties().size());
        this.myPropDefs.addAll(record.getProperties());
    }

    public PortableJointDefinition(RobotDefinitionResponse.JointDefinition jointDef) {
        if (jointDef == null) {
            throw new NullPointerException();
        }
        this.myPropDefs = jointDef.getJointProperties();
        if (jointDef instanceof PortableJointDefinition) {
            PortableJointDefinition pr = (PortableJointDefinition)jointDef;
            this.setRecord(pr.getRecord());
            return;
        }
        this.setRecord(jointDef.getJointId(), jointDef.getName(), jointDef.getDefaultPosition(), jointDef.getGoalPosition(), jointDef.getEnabled(), jointDef.getJointProperties());
    }

    public PortableJointDefinition(Joint.Id jId, String name, NormalizedDouble defPos, NormalizedDouble goalPos, boolean enabled, List<JointProperty> properties) {
        this.myPropDefs = new ArrayList<RobotDefinitionResponse.JointPropDefinition>(properties.size());
        for (JointProperty prop : properties) {
            this.myPropDefs.add(this.defineJointProperty(prop));
        }
        this.setRecord(jId, name, defPos, goalPos, enabled, this.myPropDefs);
    }

    public PortableJointDefinition(Joint joint) {
        this.myPropDefs = new ArrayList<RobotDefinitionResponse.JointPropDefinition>(joint.getProperties().size());
        for (JointProperty prop : joint.getProperties()) {
            this.myPropDefs.add(this.defineJointProperty(prop));
        }
        this.setRecord(joint.getId(), joint.getName(), joint.getDefaultPosition(), joint.getGoalPosition(), joint.getEnabled(), this.myPropDefs);
    }

    private void setRecord(Joint.Id jId, String name, NormalizedDouble defPos, NormalizedDouble goalPos, boolean enabled, List<RobotDefinitionResponse.JointPropDefinition> properties) {
        JointDefinitionRecord rec = new JointDefinitionRecord();
        rec.setJointId(Integer.valueOf(jId.getLogicalJointNumber()));
        rec.setName(name);
        rec.setDefaultPosition(Double.valueOf(defPos.getValue()));
        rec.setGoalPosition(Double.valueOf(goalPos.getValue()));
        rec.setEnabled(Boolean.valueOf(enabled));
        rec.setProperties((List)new GenericData.Array(properties.size(), Schema.createArray((Schema)JointPropDefinitionRecord.SCHEMA$)));
        this.myPropDefs = properties;
        for (RobotDefinitionResponse.JointPropDefinition prop : properties) {
            rec.getProperties().add((JointPropDefinitionRecord)prop);
        }
        this.myCachedId = jId;
        this.myCachedDefaultPosition = defPos;
        this.myCachedGoalPosition = goalPos;
        this.myRecord = rec;
    }

    private void setRecord(JointDefinitionRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Joint.Id(this.myRecord.getJointId().intValue());
        this.myCachedDefaultPosition = new NormalizedDouble(this.myRecord.getDefaultPosition().doubleValue());
        this.myCachedGoalPosition = new NormalizedDouble(this.myRecord.getGoalPosition().doubleValue());
    }

    public Joint.Id getJointId() {
        return this.myCachedId;
    }

    public String getName() {
        return this.myRecord.getName();
    }

    public NormalizedDouble getDefaultPosition() {
        return this.myCachedDefaultPosition;
    }

    public NormalizedDouble getGoalPosition() {
        return this.myCachedGoalPosition;
    }

    public boolean getEnabled() {
        return this.myRecord.getEnabled();
    }

    public List<RobotDefinitionResponse.JointPropDefinition> getJointProperties() {
        return this.myPropDefs;
    }

    public JointDefinitionRecord getRecord() {
        return this.myRecord;
    }

    private RobotDefinitionResponse.JointPropDefinition defineJointProperty(JointProperty prop) {
        JointPropDefinitionRecord def = new JointPropDefinitionRecord();
        def.setPropertyName(prop.getPropertyName());
        def.setDisplayName(prop.getDisplayName());
        Class c = prop.getPropertyClass();
        NormalizableRange r = prop.getNormalizableRange();
        if (!Number.class.isAssignableFrom(c)) {
            def.setMinValue(Double.valueOf(0.0));
            def.setMaxValue(Double.valueOf(1.0));
            def.setInitialValue(Double.valueOf(r.normalizeValue(prop.getValue()).getValue()));
        } else {
            Number n = (Number)prop.getValue();
            Number min = (Number)r.getMin();
            Number max = (Number)r.getMax();
            def.setMinValue(Double.valueOf(min.doubleValue()));
            def.setMaxValue(Double.valueOf(max.doubleValue()));
            def.setInitialValue(Double.valueOf(n.doubleValue()));
        }
        return def;
    }
}

