/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.jointgroup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.robokind.api.motion.jointgroup.JointGroup;
import org.robokind.extern.utils.xpp3.XMLUtils;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class JointGroupXMLWriter {
    private static String namespace = null;

    public static void saveJointGroup(String file, JointGroup group) throws XmlPullParserException, IOException, IllegalArgumentException, FileNotFoundException {
        XmlSerializer xs = XMLUtils.getXmlFileSerializer((String)file);
        xs.startDocument(null, null);
        xs.text("\n");
        JointGroupXMLWriter.writeJointGroup(xs, group);
        xs.endDocument();
        xs.flush();
    }

    public static void writeJointGroup(XmlSerializer xs, JointGroup group) throws IOException {
        xs.startTag(namespace, "JointGroup");
        xs.attribute(namespace, "name", group.getName());
        JointGroupXMLWriter.writeJointList(xs, group.getJointIds());
        JointGroupXMLWriter.writeGroupList(xs, group.getJointGroups());
        xs.endTag(namespace, "JointGroup");
    }

    private static void writeJointList(XmlSerializer xs, Collection<Integer> jointIds) throws IOException {
        if (jointIds == null || jointIds.isEmpty()) {
            return;
        }
        xs.startTag(namespace, "JointIds");
        for (Integer id : jointIds) {
            xs.startTag(namespace, "JointId");
            xs.text(id.toString());
            xs.endTag(namespace, "JointId");
        }
        xs.endTag(namespace, "JointIds");
    }

    private static void writeGroupList(XmlSerializer xs, List<JointGroup> groups) throws IOException {
        if (groups == null || groups.isEmpty()) {
            return;
        }
        xs.startTag(namespace, "JointGroups");
        for (JointGroup group : groups) {
            JointGroupXMLWriter.writeJointGroup(xs, group);
        }
        xs.endTag(namespace, "JointGroups");
    }
}

