/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.jflux.api.core.Adapter;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.RKLifecycleConfigUtils;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.ManagedServiceGroup;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.lifecycle.RemoteRobotHostLifecycle;
import org.robokind.api.motion.lifecycle.RobotMoveHandlerLifecycle;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.impl.messaging.config.MessagingLifecycleGroupConfigUtils;
import org.robokind.impl.messaging.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroPolymorphicSenderLifecycle;
import org.robokind.impl.messaging.utils.ConnectionUtils;
import org.robokind.impl.messaging.utils.JMSAvroPolymorphicRecordBytesAdapter;
import org.robokind.impl.motion.messaging.MotionFrameEventRecord;
import org.robokind.impl.motion.messaging.PortableMotionFrameEvent;
import org.robokind.impl.motion.messaging.PortableRobotRequest;
import org.robokind.impl.motion.messaging.PortableRobotResponse;
import org.robokind.impl.motion.messaging.RobotRequestRecord;

public class RemoteRobotHostServiceGroup
extends ManagedServiceGroup {
    private static final Logger theLogger = Logger.getLogger(RemoteRobotHostServiceGroup.class.getName());
    private static final String CONNECTION_ID = "motionConnection";
    private static final String REQUEST_DEST_ID = "robotRequest";
    private static final String RESPONSE_DEST_ID = "robotResponse";
    private static final String MOVE_DEST_ID = "robotMotionFrame";
    private static final String REQUEST_DEST = "robotRequest";
    private static final String RESPONSE_DEST = "robotResponse";
    private static final String MOVE_DEST = "motionFrame";
    private static final String REQUEST_RECEIVER_ID = "robotRequestReceiver";
    private static final String RESPONSE_SENDER_ID = "robotResponseSender";
    private static final String MOVE_RECEIVER_ID = "robotFrameReceiver";
    private static final String MOVE_HANDLER_ID = "robotMoveHandler";

    private static String getIdBase(Robot.Id robotId, String serviceId) {
        String base = "robot/" + robotId + "/" + serviceId;
        return base;
    }

    private static String getDestBase(Robot.Id robotId, String serviceId) {
        String base = "robot" + robotId + serviceId;
        base = base.replaceAll("[^a-zA-Z0-9]+", "");
        return base;
    }

    public RemoteRobotHostServiceGroup(BundleContext context, Robot.Id robotId, String hostId, String clientId, String connectionConfigId, Properties registrationProperties) {
        super((ManagedServiceFactory)new OSGiComponentFactory(context), RemoteRobotHostServiceGroup.getLifecycles(robotId, hostId, clientId), RemoteRobotHostServiceGroup.getIdBase(robotId, hostId), registrationProperties);
        String base = RemoteRobotHostServiceGroup.getIdBase(robotId, hostId);
        String dbase = RemoteRobotHostServiceGroup.getDestBase(robotId, hostId);
        RemoteRobotHostServiceGroup.connectJMS(context, connectionConfigId, RemoteRobotHostServiceGroup.id(base, CONNECTION_ID), RemoteRobotHostServiceGroup.id(base, CONNECTION_ID), RemoteRobotHostServiceGroup.id(base, "robotRequest"), RemoteRobotHostServiceGroup.dest(dbase, "robotRequest"), RemoteRobotHostServiceGroup.id(base, "robotResponse"), RemoteRobotHostServiceGroup.dest(dbase, "robotResponse"), RemoteRobotHostServiceGroup.id(base, MOVE_DEST_ID), RemoteRobotHostServiceGroup.dest(dbase, MOVE_DEST), this.myServiceProperties);
    }

    private static List<ServiceLifecycleProvider> getLifecycles(Robot.Id robotId, String hostId, String clientId) {
        String base = RemoteRobotHostServiceGroup.getIdBase(robotId, hostId);
        return RemoteRobotHostServiceGroup.getRemoteRobotHostServices(RemoteRobotHostServiceGroup.id(base, hostId), RemoteRobotHostServiceGroup.id(RemoteRobotHostServiceGroup.getIdBase(robotId, clientId), clientId), robotId, RemoteRobotHostServiceGroup.id(base, CONNECTION_ID), RemoteRobotHostServiceGroup.id(base, "robotRequest"), RemoteRobotHostServiceGroup.id(base, "robotResponse"), RemoteRobotHostServiceGroup.id(base, MOVE_DEST_ID), RemoteRobotHostServiceGroup.id(base, REQUEST_RECEIVER_ID), RemoteRobotHostServiceGroup.id(base, RESPONSE_SENDER_ID), RemoteRobotHostServiceGroup.id(base, MOVE_RECEIVER_ID), RemoteRobotHostServiceGroup.id(base, MOVE_HANDLER_ID));
    }

    private static List<ServiceLifecycleProvider> getRemoteRobotHostServices(String robotHostId, String robotClientId, Robot.Id robotId, String connectionId, String requestDestId, String responseDestId, String moveDestId, String requestReceiverId, String responseSenderId, String moveReceiverId, String moveHandlerId) {
        ArrayList<ServiceLifecycleProvider> lifecycles = new ArrayList<ServiceLifecycleProvider>();
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroPolymorphicSenderLifecycle((JMSAvroPolymorphicRecordBytesAdapter)new PortableRobotResponse.MessageRecordAdapter(), RobotResponse.class, responseSenderId, connectionId, responseDestId));
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableRobotRequest.RecordMessageAdapter(), RobotRequest.class, RobotRequestRecord.class, RobotRequestRecord.SCHEMA$, requestReceiverId, connectionId, requestDestId));
        lifecycles.add((ServiceLifecycleProvider)new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableMotionFrameEvent.RecordMessageAdapter(), MotionFrameEvent.class, MotionFrameEventRecord.class, MotionFrameEventRecord.SCHEMA$, moveReceiverId, connectionId, moveDestId));
        lifecycles.add((ServiceLifecycleProvider)new RobotMoveHandlerLifecycle(moveHandlerId, robotId));
        lifecycles.add((ServiceLifecycleProvider)new RemoteRobotHostLifecycle(robotHostId, robotClientId, robotId, requestReceiverId, responseSenderId, moveReceiverId, moveHandlerId));
        return lifecycles;
    }

    private static void connectJMS(BundleContext context, String connectionConfigId, String connectionId, String sessionId, String requestDestId, String requestDestination, String responseDestId, String responseDestination, String moveDestId, String moveDestination, Properties registrationProps) {
        try {
            theLogger.info("Registering Motion Connection and Destinations");
            new OSGiComponent(context, new RKLifecycleConfigUtils.GenericLifecycleFactory().adapt(MessagingLifecycleGroupConfigUtils.buildConnectionLifecycleConfig((String)connectionConfigId, (String)connectionId))).start();
            new OSGiComponent(context, new RKLifecycleConfigUtils.GenericLifecycleFactory().adapt(MessagingLifecycleGroupConfigUtils.buildSessionLifecycleConfig((String)connectionId, (String)sessionId))).start();
            ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{requestDestId, requestDestination, 1, registrationProps, responseDestId, responseDestination, 1, registrationProps, moveDestId, moveDestination, 1, registrationProps});
            theLogger.info("Motion Connection and Destinations Registered");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static String id(String base, String suffix) {
        return base + "/" + suffix;
    }

    private static String dest(String base, String suffix) {
        String combined = base + suffix;
        combined = combined.replaceAll("[^a-zA-Z0-9]+", "");
        return combined;
    }
}

