/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import org.apache.avro.Schema;
import org.jflux.api.core.Adapter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.api.common.services.ServiceFactory;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.motion.jointgroup.RobotJointGroupFactory;
import org.robokind.api.motion.messaging.RobotResponseFactory;
import org.robokind.api.motion.protocol.MotionFrameEvent;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.api.motion.protocol.RobotRequest;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.motion.config.RobotConfigXMLFileLoader;
import org.robokind.impl.motion.config.RobotConfigXMLReader;
import org.robokind.impl.motion.config.RobotConfigXMLStreamLoader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupXMLFileLoader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupXMLStreamLoader;
import org.robokind.impl.motion.messaging.MotionFrameEventRecord;
import org.robokind.impl.motion.messaging.PortableMotionFrameEvent;
import org.robokind.impl.motion.messaging.PortableRobotDefinitionResponse;
import org.robokind.impl.motion.messaging.PortableRobotPositionResponse;
import org.robokind.impl.motion.messaging.PortableRobotRequest;
import org.robokind.impl.motion.messaging.PortableRobotResponse;
import org.robokind.impl.motion.messaging.PortableRobotStatusResponse;
import org.robokind.impl.motion.messaging.RobotDefinitionResponseRecord;
import org.robokind.impl.motion.messaging.RobotPositionResponseRecord;
import org.robokind.impl.motion.messaging.RobotRequestRecord;
import org.robokind.impl.motion.messaging.RobotStatusResponseRecord;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigLoader;
import org.robokind.impl.motion.sync.SynchronizedRobotConfigWriter;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "MotionAPI Activation Begin.");
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotConfigXMLReader(context));
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotConfigXMLFileLoader(context));
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotConfigXMLStreamLoader(context));
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotJointGroupConfigXMLReader());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotJointGroupXMLFileLoader());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new RobotJointGroupXMLStreamLoader());
        ServiceUtils.registerFactory((BundleContext)context, (ServiceFactory)new RobotJointGroupFactory());
        ServiceUtils.registerConfigLoader((BundleContext)context, (ConfigurationLoader)new SynchronizedRobotConfigLoader());
        ServiceUtils.registerConfigWriter((BundleContext)context, (ConfigurationWriter)new SynchronizedRobotConfigWriter(), null);
        context.registerService(RobotResponseFactory.class.getName(), (Object)new PortableRobotResponse.Factory(), null);
        RKMessagingConfigUtils.registerAvroSerializationConfig(MotionFrameEvent.class, MotionFrameEventRecord.class, (Schema)MotionFrameEventRecord.SCHEMA$, (Adapter)new PortableMotionFrameEvent.MessageRecordAdapter(), (Adapter)new PortableMotionFrameEvent.RecordMessageAdapter(), (String)"application/avro", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerAvroSerializationConfig(RobotRequest.class, RobotRequestRecord.class, (Schema)RobotRequestRecord.SCHEMA$, (Adapter)new PortableRobotRequest.MessageRecordAdapter(), (Adapter)new PortableRobotRequest.RecordMessageAdapter(), (String)"application/avro", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerAvroSerializationConfig(RobotDefinitionResponse.class, RobotDefinitionResponseRecord.class, (Schema)RobotDefinitionResponseRecord.SCHEMA$, (Adapter)new PortableRobotDefinitionResponse.MessageRecordAdapter(), (Adapter)new PortableRobotDefinitionResponse.RecordMessageAdapter(), (String)"application/avro-robot-def-resp", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerAvroSerializationConfig(RobotResponse.RobotPositionResponse.class, RobotPositionResponseRecord.class, (Schema)RobotPositionResponseRecord.SCHEMA$, (Adapter)new PortableRobotPositionResponse.MessageRecordAdapter(), (Adapter)new PortableRobotPositionResponse.RecordMessageAdapter(), (String)"application/avro-robot-pos-resp", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerAvroSerializationConfig(RobotResponse.RobotStatusResponse.class, RobotStatusResponseRecord.class, (Schema)RobotStatusResponseRecord.SCHEMA$, (Adapter)new PortableRobotStatusResponse.MessageRecordAdapter(), (Adapter)new PortableRobotStatusResponse.RecordMessageAdapter(), (String)"application/avro-robot-stat-resp", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        RKMessagingConfigUtils.registerSerializationConfig(RobotResponse.class, BytesMessage.class, (Adapter)new PortableRobotResponse.MessageRecordAdapter(), (Adapter)new PortableRobotResponse.RecordMessageAdapter(), null, null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        theLogger.log(Level.INFO, "MotionAPI Activation Complete.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

