/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.serial;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.robokind.api.motion.servos.ServoController;
import org.robokind.api.motion.servos.config.ServoConfig;
import org.robokind.api.motion.servos.utils.ServoIdReader;
import org.robokind.impl.motion.config.ServoControllerConfigXMLReader;
import org.robokind.impl.motion.serial.BaudRate;
import org.robokind.impl.motion.serial.SerialServoControllerConfig;

public abstract class SerialConfigXMLReader<ServoIdType, ServoConf extends ServoConfig<ServoIdType>, SerialConf extends SerialServoControllerConfig<ServoIdType, ServoConf>>
extends ServoControllerConfigXMLReader<SerialConf> {
    private static final Logger theLogger = Logger.getLogger(SerialConfigXMLReader.class.getName());
    public static final String XML_SERVO_CONTROLLER_ID = "ServoControllerId";
    public static final String XML_CONNECTION_PARAMS = "ConnectionParameters";
    public static final String XML_PORT_NAME = "PortName";
    public static final String XML_BAUD_RATE = "BaudRate";
    public static final String XML_JOINT_PARAMS = "ServoParameters";
    public static final String XML_SERVO = "Servo";
    public static final String XML_SERVO_ID = "ServoId";
    public static final String XML_JOINT_NAME = "Name";
    public static final String XML_MIN_POSITION = "MinPosition";
    public static final String XML_MAX_POSITON = "MaxPosition";
    public static final String XML_DEFAULT_POSITON = "DefaultPosition";
    private ServoIdReader<ServoIdType> myServoIdReader;

    public SerialConfigXMLReader(ServoIdReader<ServoIdType> reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.myServoIdReader = reader;
    }

    @Override
    public SerialConf loadConfiguration(HierarchicalConfiguration param) {
        String controllerId = param.getString(XML_SERVO_CONTROLLER_ID);
        if (controllerId == null) {
            throw new NullPointerException("Could not load ServoController.Id");
        }
        SubnodeConfiguration connectionConf = param.configurationAt(XML_CONNECTION_PARAMS);
        SubnodeConfiguration servoConf = param.configurationAt(XML_JOINT_PARAMS);
        SerialConf config = this.newConfig();
        ((SerialServoControllerConfig)config).setServoControllerId(new ServoController.Id(controllerId));
        this.readConnectionParams((SerialServoControllerConfig)config, (HierarchicalConfiguration)connectionConf);
        List<ServoConf> servoConfigs = this.readServoList((HierarchicalConfiguration)servoConf);
        for (ServoConfig servoConfig : servoConfigs) {
            ((SerialServoControllerConfig)config).addServoConfig((ServoConfig)servoConfig);
        }
        return config;
    }

    private void readConnectionParams(SerialServoControllerConfig config, HierarchicalConfiguration xml) {
        String port = xml.getString(XML_PORT_NAME);
        config.setPortName(port);
        Integer rate = xml.getInt(XML_BAUD_RATE);
        config.setBaudRate(BaudRate.get(rate, BaudRate.BR115200));
    }

    private List<ServoConf> readServoList(HierarchicalConfiguration xml) {
        ArrayList<ServoConf> params = new ArrayList<ServoConf>();
        List servos = xml.configurationsAt(XML_SERVO);
        for (HierarchicalConfiguration conf : servos) {
            params.add(this.readServoParameters(conf));
        }
        return params;
    }

    private ServoConf readServoParameters(HierarchicalConfiguration xml) {
        ServoIdType id = this.readServoId(xml);
        int minPos = xml.getInt(XML_MIN_POSITION);
        int maxPos = xml.getInt(XML_MAX_POSITON);
        int defPos = xml.getInt(XML_DEFAULT_POSITON);
        String name = xml.getString(XML_JOINT_NAME, "Servo " + id);
        return this.newServoConfig(id, name, minPos, maxPos, defPos);
    }

    private ServoIdType readServoId(HierarchicalConfiguration xml) {
        String idStr = xml.getString(XML_SERVO_ID);
        if (idStr == null) {
            return null;
        }
        return (ServoIdType)this.myServoIdReader.read(idStr);
    }

    protected abstract SerialConf newConfig();

    protected abstract ServoConf newServoConfig(ServoIdType var1, String var2, int var3, int var4, int var5);
}

