/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.DefaultMotionFrame;
import org.robokind.api.motion.protocol.JointPositionMap;
import org.robokind.api.motion.protocol.MotionFrame;
import org.robokind.impl.motion.messaging.JointIdRecord;
import org.robokind.impl.motion.messaging.JointPositionRecord;
import org.robokind.impl.motion.messaging.MotionFrameRecord;
import org.robokind.impl.motion.messaging.RobotPositionMapRecord;

public class MotionMessagingUtils {
    public static MotionFrameRecord packMotionFrame(MotionFrame<Robot.RobotPositionMap> frame) {
        MotionFrameRecord frameRec = new MotionFrameRecord();
        frameRec.setMoveDurationMillisec(frame.getFrameLengthMillisec());
        frameRec.setTimestampMillisecUTC(frame.getTimestampMillisecUTC());
        Robot.RobotPositionMap start = (Robot.RobotPositionMap)frame.getPreviousPositions();
        Robot.RobotPositionMap goal = (Robot.RobotPositionMap)frame.getGoalPositions();
        if (goal == null) {
            throw new NullPointerException();
        }
        frameRec.setGoalPositions(MotionMessagingUtils.packRobotPositionMap(goal));
        if (start != null) {
            frameRec.setStartPositions(MotionMessagingUtils.packRobotPositionMap(start));
        }
        return frameRec;
    }

    public static RobotPositionMapRecord packRobotPositionMap(Robot.RobotPositionMap map) {
        RobotPositionMapRecord mapRec = new RobotPositionMapRecord();
        GenericData.Array jointPositions = new GenericData.Array(map.size(), Schema.createArray((Schema)JointPositionRecord.SCHEMA$));
        for (Map.Entry e : map.entrySet()) {
            Robot.JointId jId = (Robot.JointId)e.getKey();
            NormalizedDouble pos = (NormalizedDouble)e.getValue();
            JointPositionRecord posRec = MotionMessagingUtils.packJointPosition(jId, pos);
            jointPositions.add((Object)posRec);
        }
        mapRec.setJointPositions((List<JointPositionRecord>)jointPositions);
        return mapRec;
    }

    private static JointPositionRecord packJointPosition(Robot.JointId jointId, NormalizedDouble position) {
        JointIdRecord jointIdRec = MotionMessagingUtils.packJointId(jointId);
        JointPositionRecord posRec = new JointPositionRecord();
        posRec.setJointId(jointIdRec);
        posRec.setNormalizedPosition(position.getValue());
        return posRec;
    }

    public static JointIdRecord packJointId(Robot.JointId jointId) {
        JointIdRecord idRec = new JointIdRecord();
        idRec.setJointId(jointId.getJointId().getLogicalJointNumber());
        idRec.setRobotId(jointId.getRobotId().getRobtIdString());
        return idRec;
    }

    public static MotionFrame unpackMotionFrame(MotionFrameRecord frameRec) {
        DefaultMotionFrame frame = new DefaultMotionFrame();
        frame.setTimestampMillisecUTC(frameRec.getTimestampMillisecUTC().longValue());
        frame.setFrameLengthMillisec(frameRec.getMoveDurationMillisec().longValue());
        frame.setGoalPositions((JointPositionMap)MotionMessagingUtils.unpackPositionMap(frameRec.getGoalPositions()));
        RobotPositionMapRecord startRec = frameRec.getStartPositions();
        if (startRec != null) {
            frame.setPreviousPositions((JointPositionMap)MotionMessagingUtils.unpackPositionMap(startRec));
        }
        return frame;
    }

    public static Robot.RobotPositionMap unpackPositionMap(RobotPositionMapRecord mapRec) {
        List<JointPositionRecord> posRecs = mapRec.getJointPositions();
        Robot.RobotPositionHashMap map = new Robot.RobotPositionHashMap(posRecs.size());
        for (JointPositionRecord posRec : posRecs) {
            Map.Entry<Robot.JointId, NormalizedDouble> e = MotionMessagingUtils.unpackJointPosition(posRec);
            map.put((Object)e.getKey(), (Object)e.getValue());
        }
        return map;
    }

    private static Map.Entry<Robot.JointId, NormalizedDouble> unpackJointPosition(JointPositionRecord posRec) {
        Robot.JointId jId = MotionMessagingUtils.unpackJointId(posRec.getJointId());
        NormalizedDouble pos = new NormalizedDouble(posRec.getNormalizedPosition().doubleValue());
        AbstractMap.SimpleEntry<Robot.JointId, NormalizedDouble> e = new AbstractMap.SimpleEntry<Robot.JointId, NormalizedDouble>(jId, pos);
        return e;
    }

    public static Robot.JointId unpackJointId(JointIdRecord jointIdRec) {
        Robot.Id rId = new Robot.Id(jointIdRec.getRobotId().toString());
        Joint.Id jId = new Joint.Id(jointIdRec.getJointId().intValue());
        Robot.JointId jointId = new Robot.JointId(rId, jId);
        return jointId;
    }
}

