/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.jflux.api.core.Adapter;
import org.robokind.api.motion.Joint;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.RobotDefinitionResponse;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.impl.motion.messaging.JointDefinitionRecord;
import org.robokind.impl.motion.messaging.PortableJointDefinition;
import org.robokind.impl.motion.messaging.PortableRobotResponseHeader;
import org.robokind.impl.motion.messaging.RobotDefinitionResponseRecord;

public class PortableRobotDefinitionResponse
implements RobotDefinitionResponse {
    private RobotDefinitionResponseRecord myRecord;
    private PortableRobotResponseHeader myCachedHeader;
    private List<PortableJointDefinition> myCachedJointDefinitions;

    public PortableRobotDefinitionResponse(RobotDefinitionResponseRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedHeader = new PortableRobotResponseHeader(this.myRecord.getResponseHeader());
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>();
        for (JointDefinitionRecord rec : this.myRecord.getJoints()) {
            this.myCachedJointDefinitions.add(new PortableJointDefinition(rec));
        }
    }

    public PortableRobotDefinitionResponse(RobotDefinitionResponse response) {
        if (response == null) {
            throw new NullPointerException();
        }
        if (response instanceof PortableRobotDefinitionResponse) {
            PortableRobotDefinitionResponse pr = (PortableRobotDefinitionResponse)response;
            this.myRecord = pr.getRecord();
            this.myCachedHeader = pr.myCachedHeader;
            this.myCachedJointDefinitions = pr.myCachedJointDefinitions;
            return;
        }
        this.setHeader(response.getResponseHeader());
        this.myRecord = new RobotDefinitionResponseRecord();
        this.myRecord.setResponseHeader(this.myCachedHeader.getRecord());
        this.myRecord.setConnected(response.getConnected());
        this.myRecord.setEnabled(response.getEnabled());
        int count = response.getJointDefinitions().size();
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>(count);
        this.myRecord.setJoints((List<JointDefinitionRecord>)new GenericData.Array(count, Schema.createArray((Schema)JointDefinitionRecord.SCHEMA$)));
        for (RobotDefinitionResponse.JointDefinition def : response.getJointDefinitions()) {
            PortableJointDefinition pjd = new PortableJointDefinition(def);
            this.myCachedJointDefinitions.add(pjd);
            this.myRecord.getJoints().add(pjd.getRecord());
        }
    }

    public PortableRobotDefinitionResponse(RobotResponse.RobotResponseHeader header, boolean connected, boolean enabled, List<RobotDefinitionResponse.JointDefinition> jointDefs) {
        this.setHeader(header);
        this.myRecord = new RobotDefinitionResponseRecord();
        this.myRecord.setResponseHeader(this.myCachedHeader.getRecord());
        this.myRecord.setConnected(connected);
        this.myRecord.setEnabled(enabled);
        int count = jointDefs.size();
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>(count);
        this.myRecord.setJoints((List<JointDefinitionRecord>)new GenericData.Array(count, Schema.createArray((Schema)JointDefinitionRecord.SCHEMA$)));
        for (RobotDefinitionResponse.JointDefinition def : jointDefs) {
            PortableJointDefinition pjd = new PortableJointDefinition(def);
            this.myCachedJointDefinitions.add(pjd);
            this.myRecord.getJoints().add(pjd.getRecord());
        }
    }

    public PortableRobotDefinitionResponse(RobotResponse.RobotResponseHeader header, Robot<? extends Joint> robot) {
        if (header == null || robot == null) {
            throw new NullPointerException();
        }
        this.setHeader(header);
        this.myRecord = new RobotDefinitionResponseRecord();
        this.myRecord.setResponseHeader(this.myCachedHeader.getRecord());
        this.myRecord.setConnected(robot.isConnected());
        this.myRecord.setEnabled(robot.isEnabled());
        int count = robot.getJointList().size();
        this.myCachedJointDefinitions = new ArrayList<PortableJointDefinition>(count);
        this.myRecord.setJoints((List<JointDefinitionRecord>)new GenericData.Array(count, Schema.createArray((Schema)JointDefinitionRecord.SCHEMA$)));
        for (Joint joint : robot.getJointList()) {
            PortableJointDefinition pjd = new PortableJointDefinition(joint);
            this.myCachedJointDefinitions.add(pjd);
            this.myRecord.getJoints().add(pjd.getRecord());
        }
    }

    private void setHeader(RobotResponse.RobotResponseHeader header) {
        this.myCachedHeader = header instanceof PortableRobotResponseHeader ? (PortableRobotResponseHeader)header : new PortableRobotResponseHeader(header);
    }

    public boolean getConnected() {
        return this.myRecord.getConnected();
    }

    public boolean getEnabled() {
        return this.myRecord.getEnabled();
    }

    public List<RobotDefinitionResponse.JointDefinition> getJointDefinitions() {
        return this.myCachedJointDefinitions;
    }

    public RobotResponse.RobotResponseHeader getResponseHeader() {
        return this.myCachedHeader;
    }

    public RobotDefinitionResponseRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<RobotDefinitionResponseRecord, RobotDefinitionResponse> {
        public RobotDefinitionResponse adapt(RobotDefinitionResponseRecord a) {
            return new PortableRobotDefinitionResponse(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<RobotDefinitionResponse, RobotDefinitionResponseRecord> {
        public RobotDefinitionResponseRecord adapt(RobotDefinitionResponse a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableRobotDefinitionResponse(a).getRecord();
        }
    }
}

