/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.motion.sync;

import java.io.File;
import org.jflux.impl.messaging.rk.common.AvroUtils;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ConfigurationLoader;
import org.robokind.api.motion.sync.SynchronizedRobotConfig;
import org.robokind.impl.motion.messaging.SynchronizedRobotConfigRecord;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class SynchronizedRobotConfigLoader 
        implements ConfigurationLoader<SynchronizedRobotConfig, File> {
    /**
     * Config format version name.
     */
    public final static String VERSION_NAME = "Avro SynchronizedRobotConfig";
    /**
     * Config format type version number.
     */
    public final static String VERSION_NUMBER = "1.0";
    /**
     * Config format type VersionProperty.
     */
    public final static VersionProperty VERSION = new VersionProperty(VERSION_NAME, VERSION_NUMBER);
    

    @Override
    public VersionProperty getConfigurationFormat() {
        return VERSION;
    }

    @Override
    public SynchronizedRobotConfig loadConfiguration(File param) 
            throws Exception {
        SynchronizedRobotConfigRecord record = AvroUtils.readFromFile(
                SynchronizedRobotConfigRecord.class, null, 
                SynchronizedRobotConfigRecord.SCHEMA$, param, true);
        return new PortableSynchronizedRobotConfig(record);
    }

    @Override
    public Class<SynchronizedRobotConfig> getConfigurationClass() {
        return SynchronizedRobotConfig.class;
    }

    @Override
    public Class<File> getParameterClass() {
        return File.class;
    }
    
}
