/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.motion.messaging;

import org.robokind.api.motion.Robot;
import org.robokind.api.motion.protocol.RobotResponse;
import org.robokind.impl.motion.messaging.RobotResponseHeaderRecord;

public class PortableRobotResponseHeader
implements RobotResponse.RobotResponseHeader {
    private RobotResponseHeaderRecord myRecord;
    private Robot.Id myCachedId;

    public PortableRobotResponseHeader(RobotResponseHeaderRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myCachedId = new Robot.Id(this.myRecord.getRobotId());
    }

    public PortableRobotResponseHeader(RobotResponse.RobotResponseHeader header) {
        if (header == null) {
            throw new NullPointerException();
        }
        if (header instanceof PortableRobotResponseHeader) {
            this.myRecord = ((PortableRobotResponseHeader)header).getRecord();
            this.myCachedId = new Robot.Id(this.myRecord.getRobotId());
            return;
        }
        this.myCachedId = header.getRobotId();
        this.myRecord = new RobotResponseHeaderRecord();
        this.myRecord.setRobotId(this.myCachedId.getRobtIdString());
        this.myRecord.setRequestSourceId(header.getSourceId());
        this.myRecord.setRequestDestinationId(header.getDestinationId());
        this.myRecord.setRequestType(header.getRequestType());
        this.myRecord.setRequestTimestampMillisecUTC(header.getRequestTimestampMillisecUTC());
        this.myRecord.setResponseTimestampMillisecUTC(header.getResponseTimestampMillisecUTC());
    }

    public PortableRobotResponseHeader(Robot.Id robotId, String sourceId, String destId, String commandType, long requestTimestampMillisecUTC, long responseTimestampMillisecUTC) {
        this.myCachedId = robotId;
        this.myRecord = new RobotResponseHeaderRecord();
        this.myRecord.setRobotId(this.myCachedId.getRobtIdString());
        this.myRecord.setRequestSourceId(sourceId);
        this.myRecord.setRequestDestinationId(destId);
        this.myRecord.setRequestType(commandType);
        this.myRecord.setRequestTimestampMillisecUTC(requestTimestampMillisecUTC);
        this.myRecord.setResponseTimestampMillisecUTC(responseTimestampMillisecUTC);
    }

    public Robot.Id getRobotId() {
        return this.myCachedId;
    }

    public String getSourceId() {
        return this.myRecord.getRequestSourceId();
    }

    public String getDestinationId() {
        return this.myRecord.getRequestDestinationId();
    }

    public String getRequestType() {
        return this.myRecord.getRequestType();
    }

    public long getRequestTimestampMillisecUTC() {
        return this.myRecord.getRequestTimestampMillisecUTC();
    }

    public long getResponseTimestampMillisecUTC() {
        return this.myRecord.getResponseTimestampMillisecUTC();
    }

    public RobotResponseHeaderRecord getRecord() {
        return this.myRecord;
    }
}

