/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.speech.viseme;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData.Array;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;
import org.robokind.api.speech.viseme.config.VisemeBindingManagerConfig;
import org.robokind.avrogen.speech.viseme.VisemeBindingConfigRecord;
import org.robokind.avrogen.speech.viseme.VisemeBindingManagerConfigRecord;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableVisemeBindingManagerConfig 
        implements VisemeBindingManagerConfig{
    private VisemeBindingManagerConfigRecord myRecord;
    private List<VisemeBindingConfig> myChachedBindingConfigs;
    
    public PortableVisemeBindingManagerConfig(
            VisemeBindingManagerConfigRecord record){
        myRecord = record;
        myChachedBindingConfigs = new ArrayList(record.visemeBindings.size());
        for(VisemeBindingConfigRecord rec : record.visemeBindings){
            myChachedBindingConfigs.add(new PortableVisemeBindingConfig(rec));
        }
    }
    
    public PortableVisemeBindingManagerConfig(
            VisemeBindingManagerConfig config){
        if(config instanceof PortableVisemeBindingManagerConfig){
            PortableVisemeBindingManagerConfig pconf = 
                    (PortableVisemeBindingManagerConfig)config;
            myRecord = pconf.getRecord();
            myChachedBindingConfigs = 
                    new ArrayList(pconf.getVisemeBindingConfigs());
            return;
        }
        init(config.getVisemeBindingConfigs());
    }
    
    public PortableVisemeBindingManagerConfig(List<VisemeBindingConfig> bindingConfigs){
        init(bindingConfigs);
    }
    
    private void init(List<VisemeBindingConfig> bindingConfigs){
        myRecord = new VisemeBindingManagerConfigRecord();
        myRecord.visemeBindings = new Array<VisemeBindingConfigRecord>(
                bindingConfigs.size(), 
                Schema.createArray(VisemeBindingConfigRecord.SCHEMA$));
        myChachedBindingConfigs = 
                new ArrayList<VisemeBindingConfig>(bindingConfigs.size());
        for(VisemeBindingConfig conf : bindingConfigs){
            PortableVisemeBindingConfig pconf = 
                    new PortableVisemeBindingConfig(conf);
            myRecord.visemeBindings.add(pconf.getRecord());
            myChachedBindingConfigs.add(pconf);
        }
    }
    
    @Override
    public List<VisemeBindingConfig> getVisemeBindingConfigs() {
        return myChachedBindingConfigs;
    }
    
    public VisemeBindingManagerConfigRecord getRecord(){
        return myRecord;
    }    
}
