/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.speech.SpeechConfig;
import org.robokind.avrogen.speech.SpeechConfigRecord;
import org.robokind.impl.messaging.services.PortableServiceCommand;

public class PortableSpeechConfig
implements SpeechConfig {
    private SpeechConfigRecord myRecord;

    public PortableSpeechConfig(SpeechConfigRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableSpeechConfig(SpeechConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (config instanceof PortableServiceCommand) {
            this.myRecord = ((PortableSpeechConfig)config).getRecord();
            return;
        }
        this.setRecord(config.getSpeechServiceId(), config.getConfigSourceId(), config.getVoiceName(), config.getSampleRate());
    }

    public PortableSpeechConfig(String speechServiceId, String configSourceId, String voiceName, double sampleRate) {
        this.setRecord(speechServiceId, configSourceId, voiceName, sampleRate);
    }

    private void setRecord(String speechServiceId, String configSourceId, String voiceName, double sampleRate) {
        if (speechServiceId == null || configSourceId == null || voiceName == null) {
            throw new NullPointerException();
        }
        this.myRecord = new SpeechConfigRecord();
        this.myRecord.speechServiceId = new Utf8(speechServiceId);
        this.myRecord.configSourceId = new Utf8(configSourceId);
        this.myRecord.voiceName = new Utf8(voiceName);
        this.myRecord.sampleRate = sampleRate;
    }

    public String getSpeechServiceId() {
        return this.myRecord.speechServiceId.toString();
    }

    public String getConfigSourceId() {
        return this.myRecord.configSourceId.toString();
    }

    public String getVoiceName() {
        return this.myRecord.voiceName.toString();
    }

    public double getSampleRate() {
        return this.myRecord.sampleRate;
    }

    public SpeechConfigRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechConfigRecord, SpeechConfig> {
        public SpeechConfig adapt(SpeechConfigRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechConfig(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechConfig, SpeechConfigRecord> {
        public SpeechConfigRecord adapt(SpeechConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechConfig(a).getRecord();
        }
    }
}

