/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.avrogen.speech.SpeechEventRecord;

public class PortableSpeechEvent
implements SpeechEvent {
    private SpeechEventRecord myRecord;
    long myTimestampUTC;

    public PortableSpeechEvent(SpeechEventRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableSpeechEvent(SpeechEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (event instanceof PortableSpeechEvent) {
            this.myRecord = ((PortableSpeechEvent)event).getRecord();
            return;
        }
        this.setRecord(event.getSpeechEventType(), event.getStreamNumber(), event.getTextPosition(), event.getTextLength(), event.getCurrentData(), event.getNextData(), event.getStringData(), event.getDuration());
    }

    public PortableSpeechEvent(String speechEventType, long streamNumber, int textPosition, int textLength, int currentData, int nextData, String stringData, int duration) {
        this.setRecord(speechEventType, streamNumber, textPosition, textLength, currentData, nextData, stringData, duration);
    }

    private void setRecord(String speechEventType, long streamNumber, int textPosition, int textLength, int currentData, int nextData, String stringData, int duration) {
        this.myRecord = new SpeechEventRecord();
        this.myRecord.eventType = new Utf8(speechEventType);
        this.myRecord.streamNumber = streamNumber;
        this.myRecord.textPosition = textPosition;
        this.myRecord.textLength = textLength;
        this.myRecord.currentData = currentData;
        this.myRecord.nextData = nextData;
        this.myRecord.stringData = new Utf8(stringData);
        this.myRecord.duration = duration;
    }

    public String getSpeechEventType() {
        return this.myRecord.eventType.toString();
    }

    public Long getStreamNumber() {
        return this.myRecord.streamNumber;
    }

    public Integer getTextPosition() {
        return this.myRecord.textPosition;
    }

    public Integer getTextLength() {
        return this.myRecord.textLength;
    }

    public Integer getCurrentData() {
        return this.myRecord.currentData;
    }

    public Integer getNextData() {
        return this.myRecord.nextData;
    }

    public String getStringData() {
        return this.myRecord.stringData.toString();
    }

    public Integer getDuration() {
        return this.myRecord.duration;
    }

    public long getTimestampMillisecUTC() {
        return this.myTimestampUTC;
    }

    public void setTimestampMillisecUTC(long timestamp) {
        this.myTimestampUTC = timestamp;
    }

    public SpeechEventRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechEventRecord, SpeechEvent> {
        public SpeechEvent adapt(SpeechEventRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechEvent(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechEvent, SpeechEventRecord> {
        public SpeechEventRecord adapt(SpeechEvent a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechEvent(a).getRecord();
        }
    }
}

