/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.speech.SpeechEvent;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.avrogen.speech.SpeechEventListRecord;
import org.robokind.avrogen.speech.SpeechEventRecord;
import org.robokind.impl.speech.PortableSpeechEvent;

public class PortableSpeechEventList
implements SpeechEventList {
    private SpeechEventListRecord myListRecord;
    private List<SpeechEvent> myEvents;

    public PortableSpeechEventList(SpeechEventListRecord record) {
        this.setRecord(record);
    }

    public PortableSpeechEventList(SpeechEventList eventList) {
        if (eventList == null) {
            throw new NullPointerException();
        }
        if (eventList instanceof PortableSpeechEventList) {
            this.setRecord(((PortableSpeechEventList)eventList).getRecord());
        }
        this.myListRecord = new SpeechEventListRecord();
        List events = eventList.getSpeechEvents();
        this.myListRecord.speechEvents = new GenericData.Array(events.size(), Schema.createArray((Schema)SpeechEventListRecord.SCHEMA$));
        this.myEvents = new ArrayList<SpeechEvent>(events.size());
        for (SpeechEvent event : events) {
            PortableSpeechEvent e = new PortableSpeechEvent(event);
            e.setTimestampMillisecUTC(eventList.getTimestampMillisecUTC());
            this.myEvents.add(event);
            this.myListRecord.speechEvents.add((Object)e.getRecord());
        }
        this.myListRecord.speechServiceId = new Utf8(eventList.getSpeechServiceId());
        this.myListRecord.timestampMillisecUTC = eventList.getTimestampMillisecUTC();
    }

    private void setRecord(SpeechEventListRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myListRecord = record;
        this.myEvents = new ArrayList<SpeechEvent>(this.myListRecord.speechEvents.size());
        PortableSpeechEvent.RecordMessageAdapter adapter = new PortableSpeechEvent.RecordMessageAdapter();
        for (SpeechEventRecord rec : this.myListRecord.speechEvents) {
            SpeechEvent ev = (SpeechEvent)adapter.adapt(rec);
            if (ev instanceof PortableSpeechEvent) {
                ((PortableSpeechEvent)ev).setTimestampMillisecUTC(record.timestampMillisecUTC);
            }
            this.myEvents.add(ev);
        }
    }

    public String getSpeechServiceId() {
        return this.myListRecord.speechServiceId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myListRecord.timestampMillisecUTC;
    }

    public List<SpeechEvent> getSpeechEvents() {
        return this.myEvents;
    }

    public SpeechEventListRecord getRecord() {
        return this.myListRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechEventListRecord, SpeechEventList> {
        public SpeechEventList adapt(SpeechEventListRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechEventList(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechEventList, SpeechEventListRecord> {
        public SpeechEventListRecord adapt(SpeechEventList a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechEventList(a).getRecord();
        }
    }
}

