/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.SpeechRequestFactory;
import org.robokind.avrogen.speech.SpeechRequestRecord;

public class PortableSpeechRequest
implements SpeechRequest {
    private SpeechRequestRecord myRequestRecord;

    public PortableSpeechRequest(SpeechRequestRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRequestRecord = record;
    }

    public PortableSpeechRequest(String speechServiceId, String requestSourceId, long timestampMillisecUTC, String phrase) {
        if (speechServiceId == null || requestSourceId == null || phrase == null) {
            throw new NullPointerException();
        }
        this.myRequestRecord = new SpeechRequestRecord();
        this.myRequestRecord.speechServiceId = new Utf8(speechServiceId);
        this.myRequestRecord.requestSourceId = new Utf8(requestSourceId);
        this.myRequestRecord.timestampMillisecUTC = timestampMillisecUTC;
        this.myRequestRecord.phrase = new Utf8(phrase);
    }

    public PortableSpeechRequest(SpeechRequest req) {
        if (req instanceof PortableSpeechRequest) {
            this.myRequestRecord = ((PortableSpeechRequest)req).getRecord();
            return;
        }
        if (req.getSpeechServiceId() == null || req.getRequestSourceId() == null || req.getPhrase() == null) {
            throw new NullPointerException();
        }
        this.myRequestRecord = new SpeechRequestRecord();
        this.myRequestRecord.speechServiceId = new Utf8(req.getSpeechServiceId());
        this.myRequestRecord.requestSourceId = new Utf8(req.getRequestSourceId());
        this.myRequestRecord.timestampMillisecUTC = req.getTimestampMillisecUTC();
        this.myRequestRecord.phrase = new Utf8(req.getPhrase());
    }

    public SpeechRequestRecord getRecord() {
        return this.myRequestRecord;
    }

    public String getSpeechServiceId() {
        return this.myRequestRecord.speechServiceId.toString();
    }

    public String getRequestSourceId() {
        return this.myRequestRecord.requestSourceId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRequestRecord.timestampMillisecUTC;
    }

    public String getPhrase() {
        return this.myRequestRecord.phrase.toString();
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechRequestRecord, SpeechRequest> {
        public SpeechRequest adapt(SpeechRequestRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRequest(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechRequest, SpeechRequestRecord> {
        public SpeechRequestRecord adapt(SpeechRequest a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRequest(a).getRecord();
        }
    }

    public static class Factory
    implements SpeechRequestFactory {
        public SpeechRequest create(String clientId, String hostId, String phrase) {
            return new PortableSpeechRequest(hostId, clientId, TimeUtils.now(), phrase);
        }
    }
}

