/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech.viseme;

import java.util.EnumMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.robokind.api.common.position.NormalizedDouble;
import org.robokind.api.common.utils.Utils;
import org.robokind.api.speech.viseme.Viseme;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;
import org.robokind.avrogen.speech.viseme.VisemeBindingConfigRecord;
import org.robokind.avrogen.speech.viseme.VisemePositionRecord;

public class PortableVisemeBindingConfig
implements VisemeBindingConfig {
    private VisemeBindingConfigRecord myRecord;
    private Map<Viseme, NormalizedDouble> myCachedPositions;

    public PortableVisemeBindingConfig(VisemeBindingConfigRecord record) {
        this.myRecord = record;
        this.myCachedPositions = new EnumMap<Viseme, NormalizedDouble>(Viseme.class);
        for (VisemePositionRecord pos : record.visemeBindings) {
            int id = pos.visemeId;
            Viseme vis = Viseme.getById((int)id);
            double boundPos = Utils.bound((double)pos.position, (double)0.0, (double)1.0);
            NormalizedDouble val = new NormalizedDouble(boundPos);
            this.myCachedPositions.put(vis, val);
        }
    }

    public PortableVisemeBindingConfig(VisemeBindingConfig conf) {
        if (conf instanceof PortableVisemeBindingConfig) {
            this.myRecord = ((PortableVisemeBindingConfig)conf).getRecord();
            this.myCachedPositions = conf.getVisemeValues();
            return;
        }
        this.init(conf.getBindingKey(), conf.getVisemeValues());
    }

    public PortableVisemeBindingConfig(int bindingId, Map<Viseme, NormalizedDouble> visPos) {
        this.init(bindingId, visPos);
    }

    private void init(int bindingId, Map<Viseme, NormalizedDouble> visPos) {
        this.myRecord = new VisemeBindingConfigRecord();
        this.myRecord.bindingId = bindingId;
        this.myRecord.visemeBindings = new GenericData.Array(visPos.size(), Schema.createArray((Schema)VisemePositionRecord.SCHEMA$));
        for (Map.Entry<Viseme, NormalizedDouble> e : visPos.entrySet()) {
            VisemePositionRecord posRec = new VisemePositionRecord();
            posRec.visemeId = e.getKey().getVisemeId();
            posRec.position = e.getValue().getValue();
            this.myRecord.visemeBindings.add((Object)posRec);
        }
        this.myCachedPositions = new EnumMap<Viseme, NormalizedDouble>(visPos);
    }

    public int getBindingKey() {
        return this.myRecord.bindingId;
    }

    public Map<Viseme, NormalizedDouble> getVisemeValues() {
        return this.myCachedPositions;
    }

    public VisemeBindingConfigRecord getRecord() {
        return this.myRecord;
    }
}

