/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech.viseme;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.robokind.api.speech.viseme.config.VisemeBindingConfig;
import org.robokind.api.speech.viseme.config.VisemeBindingManagerConfig;
import org.robokind.avrogen.speech.viseme.VisemeBindingConfigRecord;
import org.robokind.avrogen.speech.viseme.VisemeBindingManagerConfigRecord;
import org.robokind.impl.speech.viseme.PortableVisemeBindingConfig;

public class PortableVisemeBindingManagerConfig
implements VisemeBindingManagerConfig {
    private VisemeBindingManagerConfigRecord myRecord;
    private List<VisemeBindingConfig> myChachedBindingConfigs;

    public PortableVisemeBindingManagerConfig(VisemeBindingManagerConfigRecord record) {
        this.myRecord = record;
        this.myChachedBindingConfigs = new ArrayList<VisemeBindingConfig>(record.visemeBindings.size());
        for (VisemeBindingConfigRecord rec : record.visemeBindings) {
            this.myChachedBindingConfigs.add(new PortableVisemeBindingConfig(rec));
        }
    }

    public PortableVisemeBindingManagerConfig(VisemeBindingManagerConfig config) {
        if (config instanceof PortableVisemeBindingManagerConfig) {
            PortableVisemeBindingManagerConfig pconf = (PortableVisemeBindingManagerConfig)config;
            this.myRecord = pconf.getRecord();
            this.myChachedBindingConfigs = new ArrayList<VisemeBindingConfig>(pconf.getVisemeBindingConfigs());
            return;
        }
        this.init(config.getVisemeBindingConfigs());
    }

    public PortableVisemeBindingManagerConfig(List<VisemeBindingConfig> bindingConfigs) {
        this.init(bindingConfigs);
    }

    private void init(List<VisemeBindingConfig> bindingConfigs) {
        this.myRecord = new VisemeBindingManagerConfigRecord();
        this.myRecord.visemeBindings = new GenericData.Array(bindingConfigs.size(), Schema.createArray((Schema)VisemeBindingConfigRecord.SCHEMA$));
        this.myChachedBindingConfigs = new ArrayList<VisemeBindingConfig>(bindingConfigs.size());
        for (VisemeBindingConfig conf : bindingConfigs) {
            PortableVisemeBindingConfig pconf = new PortableVisemeBindingConfig(conf);
            this.myRecord.visemeBindings.add((Object)pconf.getRecord());
            this.myChachedBindingConfigs.add(pconf);
        }
    }

    public List<VisemeBindingConfig> getVisemeBindingConfigs() {
        return this.myChachedBindingConfigs;
    }

    public VisemeBindingManagerConfigRecord getRecord() {
        return this.myRecord;
    }
}

