/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech;

import java.util.Properties;
import java.util.logging.Logger;
import org.jflux.api.core.Listener;
import org.jflux.api.core.config.Configuration;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.speech.SpeechConfig;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.lifecycle.RemoteSpeechServiceLifecycle;
import org.robokind.api.speech.viseme.lifecycle.VisemeEventNotifierLifecycle;
import org.robokind.impl.messaging.config.DependentLifecycle;
import org.robokind.impl.messaging.config.MessagingLifecycleGroupConfigUtils;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;

public class RemoteSpeechUtils {
    private static final Logger theLogger = Logger.getLogger(RemoteSpeechUtils.class.getName());
    private static final String COMMAND_DEST_CONFIG_ID = "speechCommandDestConfig";
    private static final String CONFIG_DEST_CONFIG_ID = "speechConfigDestConfig";
    private static final String ERROR_DEST_CONFIG_ID = "speechErrorDestConfig";
    private static final String REQUEST_DEST_CONFIG_ID = "speechRequestDestConfig";
    private static final String EVENT_DEST_CONFIG_ID = "speechEventDestConfig";
    private static final String COMMAND_SERIALIZE_CONFIG_ID = ServiceCommand.class.toString();
    private static final String CONFIG_SERIALIZE_CONFIG_ID = SpeechConfig.class.toString();
    private static final String ERROR_SERIALIZE_CONFIG_ID = ServiceError.class.toString();
    private static final String REQUEST_SERIALIZE_CONFIG_ID = SpeechRequest.class.toString();
    private static final String EVENT_SERIALIZE_CONFIG_ID = SpeechEventList.class.toString();
    private static final String COMMAND_DEST_NAME = "speechCommand";
    private static final String CONFIG_DEST_NAME = "speechCommand";
    private static final String ERROR_DEST_NAME = "speechError";
    private static final String REQUEST_DEST_NAME = "speechRequest";
    private static final String EVENT_DEST_NAME = "speechEvent";
    private static final String COMMAND_SENDER_ID = "speechCommand";
    private static final String CONFIG_SENDER_ID = "speechConfig";
    private static final String ERROR_RECEIVER_ID = "speechError";
    private static final String REQUEST_SENDER_ID = "speechRequest";
    private static final String EVENT_RECEIVER_ID = "speechEvent";
    public static final String GROUP_PREFIX = "RKSpeechGroup";

    public static void connect(BundleContext context, String speechGroupId, String connectionConfigId) {
        if (context == null || speechGroupId == null || connectionConfigId == null) {
            throw new NullPointerException();
        }
        OSGiComponentFactory fact = new OSGiComponentFactory(context);
        RemoteSpeechUtils.registerDestConfigs((ManagedServiceFactory)fact);
        RemoteSpeechUtils.launchComponents(speechGroupId, connectionConfigId, null, (ManagedServiceFactory)fact);
        new OSGiComponent(context, (ServiceLifecycleProvider)new VisemeEventNotifierLifecycle(speechGroupId)).start();
        RemoteSpeechUtils.launchRemoteSpeechClient(context, speechGroupId, speechGroupId, "speechCommand", CONFIG_SENDER_ID, "speechError", "speechRequest", "speechEvent");
    }

    private static void registerDestConfigs(ManagedServiceFactory fact) {
        RKMessagingConfigUtils.registerQueueConfig((String)COMMAND_DEST_CONFIG_ID, (String)"speechCommand", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerQueueConfig((String)CONFIG_DEST_CONFIG_ID, (String)"speechCommand", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerTopicConfig((String)ERROR_DEST_CONFIG_ID, (String)"speechError", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerQueueConfig((String)REQUEST_DEST_CONFIG_ID, (String)"speechRequest", null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerTopicConfig((String)EVENT_DEST_CONFIG_ID, (String)"speechEvent", null, (ManagedServiceFactory)fact);
    }

    private static void launchComponents(String groupId, String connectionConfigId, Properties props, ManagedServiceFactory fact) {
        groupId = groupId + "/RKSpeechGroup";
        RemoteSpeechUtils.launchComponent(groupId + "/" + "speechCommand", props, 0, COMMAND_DEST_CONFIG_ID, connectionConfigId, COMMAND_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(groupId + "/" + CONFIG_SENDER_ID, props, 0, CONFIG_DEST_CONFIG_ID, connectionConfigId, CONFIG_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(groupId + "/" + "speechError", props, 1, ERROR_DEST_CONFIG_ID, connectionConfigId, ERROR_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(groupId + "/" + "speechRequest", props, 0, REQUEST_DEST_CONFIG_ID, connectionConfigId, REQUEST_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(groupId + "/" + "speechEvent", props, 1, EVENT_DEST_CONFIG_ID, connectionConfigId, EVENT_SERIALIZE_CONFIG_ID, fact);
    }

    private static String launchComponent(final String groupId, final Properties props, final int componentType, final String destinationConfigId, final String connectionConfigId, String serializeConfigId, ManagedServiceFactory fact) {
        final RKManagedGroupConfigUtils.ManagedGroupFactory mgf = new RKManagedGroupConfigUtils.ManagedGroupFactory(fact);
        DependentLifecycle.createDependencyListener((String)"messagingSerializationConfig", (String)serializeConfigId, Configuration.class, (Listener)new Listener<Configuration<String>>(){

            public void handleEvent(Configuration<String> event) {
                mgf.adapt(MessagingLifecycleGroupConfigUtils.buildMessagingComponentLifecycleGroupConfig((String)groupId, (Properties)props, (int)componentType, event, (String)destinationConfigId, (String)connectionConfigId));
            }
        }, (ManagedServiceFactory)fact);
        return RemoteSpeechUtils.groupId(groupId, groupId, groupId);
    }

    private static void launchRemoteSpeechClient(BundleContext context, String speechClientId, String speechHostId, String commandSenderId, String configSenderId, String errorReceiverId, String speechRequestSenderId, String speechEventsReceiverId) {
        String idBase = speechClientId + "/" + GROUP_PREFIX;
        RemoteSpeechServiceLifecycle lifecycle = new RemoteSpeechServiceLifecycle(speechClientId, speechHostId, RemoteSpeechUtils.groupId(idBase, commandSenderId, "remoteNotifier"), RemoteSpeechUtils.groupId(idBase, configSenderId, "remoteNotifier"), RemoteSpeechUtils.groupId(idBase, errorReceiverId, "remoteListener"), RemoteSpeechUtils.groupId(idBase, speechRequestSenderId, "remoteNotifier"), RemoteSpeechUtils.groupId(idBase, speechEventsReceiverId, "remoteListener"));
        OSGiComponent speechComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        speechComp.start();
    }

    private static String groupId(String groupId, String suffix, String component) {
        return MessagingLifecycleGroupConfigUtils.childId((String)(groupId + "/" + suffix), (String)component);
    }
}

