/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speech;

import java.util.Properties;
import org.jflux.api.core.Listener;
import org.jflux.api.core.config.Configuration;
import org.jflux.impl.services.rk.lifecycle.ManagedService;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.config.RKManagedGroupConfigUtils;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.speech.SpeechConfig;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.lifecycle.RemoteSpeechServiceClientLifecycle;
import org.robokind.api.speech.viseme.lifecycle.VisemeEventNotifierLifecycle;
import org.robokind.impl.messaging.config.DependentLifecycle;
import org.robokind.impl.messaging.config.MessagingLifecycleGroupConfigUtils;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;

public class RemoteSpeechUtils {
    private static final String COMMAND_DEST_CONFIG_ID = "CommandDestConfig";
    private static final String CONFIG_DEST_CONFIG_ID = "ConfigDestConfig";
    private static final String ERROR_DEST_CONFIG_ID = "ErrorDestConfig";
    private static final String REQUEST_DEST_CONFIG_ID = "RequestDestConfig";
    private static final String EVENT_DEST_CONFIG_ID = "EventDestConfig";
    private static final String COMMAND_SERIALIZE_CONFIG_ID = ServiceCommand.class.toString();
    private static final String CONFIG_SERIALIZE_CONFIG_ID = SpeechConfig.class.toString();
    private static final String ERROR_SERIALIZE_CONFIG_ID = ServiceError.class.toString();
    private static final String REQUEST_SERIALIZE_CONFIG_ID = SpeechRequest.class.toString();
    private static final String EVENT_SERIALIZE_CONFIG_ID = SpeechEventList.class.toString();
    private static final String COMMAND_DEST_NAME = "Command";
    private static final String CONFIG_DEST_NAME = "Command";
    private static final String ERROR_DEST_NAME = "Error";
    private static final String REQUEST_DEST_NAME = "Request";
    private static final String EVENT_DEST_NAME = "Event";
    private static final String COMMAND_SENDER_ID = "Command";
    private static final String CONFIG_SENDER_ID = "Config";
    private static final String ERROR_RECEIVER_ID = "Error";
    private static final String REQUEST_SENDER_ID = "Request";
    private static final String EVENT_RECEIVER_ID = "Event";
    public static final String GROUP_PREFIX = "RKSpeechGroup";

    public static void connect(ManagedServiceFactory fact, String speechGroupId, String speechPrefix, String connectionConfigId) {
        if (fact == null || speechGroupId == null || connectionConfigId == null) {
            throw new NullPointerException();
        }
        RemoteSpeechUtils.registerDestConfigs(speechGroupId, speechPrefix, fact);
        RemoteSpeechUtils.launchComponents(speechGroupId, connectionConfigId, speechPrefix, null, fact);
        fact.createService((ServiceLifecycleProvider)new VisemeEventNotifierLifecycle(speechGroupId), null).start();
        RemoteSpeechUtils.launchRemoteSpeechClient(fact, speechGroupId, speechGroupId, speechPrefix + "Command", speechPrefix + CONFIG_SENDER_ID, speechPrefix + "Error", speechPrefix + "Request", speechPrefix + "Event");
    }

    private static void registerDestConfigs(String groupId, String speechPrefix, ManagedServiceFactory fact) {
        String idBase = groupId + "/" + GROUP_PREFIX;
        String destBase = "";
        RKMessagingConfigUtils.registerQueueConfig((String)(idBase + "/" + speechPrefix + COMMAND_DEST_CONFIG_ID), (String)(destBase + speechPrefix + "Command"), null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerQueueConfig((String)(idBase + "/" + speechPrefix + CONFIG_DEST_CONFIG_ID), (String)(destBase + speechPrefix + "Command"), null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerTopicConfig((String)(idBase + "/" + speechPrefix + ERROR_DEST_CONFIG_ID), (String)(destBase + speechPrefix + "Error"), null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerQueueConfig((String)(idBase + "/" + speechPrefix + REQUEST_DEST_CONFIG_ID), (String)(destBase + speechPrefix + "Request"), null, (ManagedServiceFactory)fact);
        RKMessagingConfigUtils.registerTopicConfig((String)(idBase + "/" + speechPrefix + EVENT_DEST_CONFIG_ID), (String)(destBase + speechPrefix + "Event"), null, (ManagedServiceFactory)fact);
    }

    private static void launchComponents(String groupId, String connectionConfigId, String speechPrefix, Properties props, ManagedServiceFactory fact) {
        String idBase = groupId + "/" + GROUP_PREFIX;
        RemoteSpeechUtils.launchComponent(idBase + "/" + speechPrefix + "Command", props, 0, idBase + "/" + speechPrefix + COMMAND_DEST_CONFIG_ID, connectionConfigId, COMMAND_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(idBase + "/" + speechPrefix + CONFIG_SENDER_ID, props, 0, idBase + "/" + speechPrefix + CONFIG_DEST_CONFIG_ID, connectionConfigId, CONFIG_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(idBase + "/" + speechPrefix + "Error", props, 1, idBase + "/" + speechPrefix + ERROR_DEST_CONFIG_ID, connectionConfigId, ERROR_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(idBase + "/" + speechPrefix + "Request", props, 0, idBase + "/" + speechPrefix + REQUEST_DEST_CONFIG_ID, connectionConfigId, REQUEST_SERIALIZE_CONFIG_ID, fact);
        RemoteSpeechUtils.launchComponent(idBase + "/" + speechPrefix + "Event", props, 1, idBase + "/" + speechPrefix + EVENT_DEST_CONFIG_ID, connectionConfigId, EVENT_SERIALIZE_CONFIG_ID, fact);
    }

    private static String launchComponent(final String groupId, final Properties props, final int componentType, final String destinationConfigId, final String connectionConfigId, String serializeConfigId, ManagedServiceFactory fact) {
        final RKManagedGroupConfigUtils.ManagedGroupFactory mgf = new RKManagedGroupConfigUtils.ManagedGroupFactory(fact);
        DependentLifecycle.createDependencyListener((String)"messagingSerializationConfig", (String)serializeConfigId, Configuration.class, (Listener)new Listener<Configuration<String>>(){

            public void handleEvent(Configuration<String> event) {
                mgf.adapt(MessagingLifecycleGroupConfigUtils.buildMessagingComponentLifecycleGroupConfig((String)groupId, (Properties)props, (int)componentType, event, (String)destinationConfigId, (String)connectionConfigId));
            }
        }, (ManagedServiceFactory)fact);
        return RemoteSpeechUtils.groupId(groupId, groupId, groupId);
    }

    private static void launchRemoteSpeechClient(ManagedServiceFactory fact, String speechClientId, String speechHostId, String commandSenderId, String configSenderId, String errorReceiverId, String speechRequestSenderId, String speechEventsReceiverId) {
        String idBase = speechClientId + "/" + GROUP_PREFIX;
        RemoteSpeechServiceClientLifecycle lifecycle = new RemoteSpeechServiceClientLifecycle(speechClientId, speechHostId, RemoteSpeechUtils.groupId(idBase, commandSenderId, "remoteNotifier"), RemoteSpeechUtils.groupId(idBase, configSenderId, "remoteNotifier"), RemoteSpeechUtils.groupId(idBase, errorReceiverId, "remoteListener"), RemoteSpeechUtils.groupId(idBase, speechRequestSenderId, "remoteNotifier"), RemoteSpeechUtils.groupId(idBase, speechEventsReceiverId, "remoteListener"));
        ManagedService speechComp = fact.createService((ServiceLifecycleProvider)lifecycle, null);
        speechComp.start();
    }

    private static String groupId(String groupId, String suffix, String component) {
        return MessagingLifecycleGroupConfigUtils.childId((String)(groupId + "/" + suffix), (String)component);
    }
}

