/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speechrec;

import org.apache.avro.util.Utf8;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.speechrec.SpeechRecEvent;
import org.robokind.avrogen.speechrec.SpeechRecEventRecord;

public class PortableSpeechRecEvent
implements SpeechRecEvent {
    private SpeechRecEventRecord myRecord;

    public PortableSpeechRecEvent(SpeechRecEventRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableSpeechRecEvent(SpeechRecEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (event instanceof PortableSpeechRecEvent) {
            this.myRecord = ((PortableSpeechRecEvent)event).getRecord();
            return;
        }
        this.setRecord(event.getRecognizerId(), event.getRecognizedText(), event.getConfidence(), event.getTimestampMillisecUTC());
    }

    public PortableSpeechRecEvent(String recognizerId, String phrase, double conf, long timestamp) {
        this.setRecord(recognizerId, phrase, conf, timestamp);
    }

    private void setRecord(String recognizerId, String phrase, double conf, long timestamp) {
        this.myRecord = new SpeechRecEventRecord();
        this.myRecord.timestampMillisecUTC = TimeUtils.now();
        this.myRecord.recognizerId = new Utf8(recognizerId);
        this.myRecord.recognizedText = new Utf8(phrase);
        this.myRecord.confidence = conf;
    }

    public String getRecognizerId() {
        return this.myRecord.recognizerId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public String getRecognizedText() {
        return this.myRecord.recognizedText.toString();
    }

    public double getConfidence() {
        return this.myRecord.confidence;
    }

    public SpeechRecEventRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechRecEventRecord, SpeechRecEvent> {
        public SpeechRecEvent adapt(SpeechRecEventRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRecEvent(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechRecEvent, SpeechRecEventRecord> {
        public SpeechRecEventRecord adapt(SpeechRecEvent a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRecEvent(a).getRecord();
        }
    }
}

