/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speechrec;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.speechrec.SpeechRecEvent;
import org.robokind.api.speechrec.SpeechRecEventList;
import org.robokind.avrogen.speechrec.SpeechRecEventListRecord;
import org.robokind.avrogen.speechrec.SpeechRecEventRecord;
import org.robokind.impl.speechrec.PortableSpeechRecEvent;

public class PortableSpeechRecEventList
implements SpeechRecEventList {
    private SpeechRecEventListRecord myRecord;
    private List<SpeechRecEvent> myEvents;

    public PortableSpeechRecEventList(SpeechRecEventListRecord record) {
        this.setRecord(record);
    }

    public PortableSpeechRecEventList(SpeechRecEventList eventList) {
        if (eventList == null) {
            throw new NullPointerException();
        }
        if (eventList instanceof PortableSpeechRecEventList) {
            this.setRecord(((PortableSpeechRecEventList)eventList).getRecord());
        }
        this.myRecord = new SpeechRecEventListRecord();
        List events = eventList.getSpeechRecEvents();
        this.myRecord.speechRecEvents = new GenericData.Array(events.size(), Schema.createArray((Schema)SpeechRecEventListRecord.SCHEMA$));
        this.myEvents = new ArrayList<SpeechRecEvent>(events.size());
        for (SpeechRecEvent event : events) {
            PortableSpeechRecEvent e = new PortableSpeechRecEvent(event);
            this.myEvents.add(event);
            this.myRecord.speechRecEvents.add((Object)e.getRecord());
        }
        this.myRecord.speechRecServiceId = new Utf8(eventList.getSpeechRecServiceId());
        this.myRecord.timestampMillisecUTC = eventList.getTimestampMillisecUTC();
        this.myRecord.eventDestinationId = new Utf8(eventList.getEventDestinationId());
    }

    public PortableSpeechRecEventList(String sourceId, String destId, List<SpeechRecEvent> events, long timestamp) {
        if (sourceId == null || destId == null || events == null) {
            throw new NullPointerException();
        }
        this.myRecord = new SpeechRecEventListRecord();
        this.myRecord.speechRecEvents = new GenericData.Array(events.size(), Schema.createArray((Schema)SpeechRecEventListRecord.SCHEMA$));
        this.myEvents = new ArrayList<SpeechRecEvent>(events.size());
        for (SpeechRecEvent event : events) {
            PortableSpeechRecEvent e = new PortableSpeechRecEvent(event);
            this.myEvents.add(event);
            this.myRecord.speechRecEvents.add((Object)e.getRecord());
        }
        this.myRecord.speechRecServiceId = new Utf8(sourceId);
        this.myRecord.timestampMillisecUTC = timestamp;
        this.myRecord.eventDestinationId = new Utf8(destId);
    }

    private void setRecord(SpeechRecEventListRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
        this.myEvents = new ArrayList<SpeechRecEvent>(this.myRecord.speechRecEvents.size());
        PortableSpeechRecEvent.RecordMessageAdapter adapter = new PortableSpeechRecEvent.RecordMessageAdapter();
        for (SpeechRecEventRecord rec : this.myRecord.speechRecEvents) {
            this.myEvents.add((SpeechRecEvent)adapter.adapt(rec));
        }
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public String getSpeechRecServiceId() {
        return this.myRecord.speechRecServiceId.toString();
    }

    public String getEventDestinationId() {
        return this.myRecord.eventDestinationId.toString();
    }

    public List<SpeechRecEvent> getSpeechRecEvents() {
        return this.myEvents;
    }

    public SpeechRecEventListRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechRecEventListRecord, SpeechRecEventList> {
        public SpeechRecEventList adapt(SpeechRecEventListRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRecEventList(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechRecEventList, SpeechRecEventListRecord> {
        public SpeechRecEventListRecord adapt(SpeechRecEventList a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRecEventList(a).getRecord();
        }
    }
}

