/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.speechrec;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.speechrec.SpeechRecConfig;
import org.robokind.api.speechrec.utils.SpeechRecConfigFactory;
import org.robokind.avrogen.speechrec.SpeechRecConfigRecord;
import org.robokind.impl.messaging.services.PortableServiceCommand;

public class PortableSpeechRecConfig
implements SpeechRecConfig {
    private SpeechRecConfigRecord myRecord;

    public PortableSpeechRecConfig(SpeechRecConfigRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableSpeechRecConfig(SpeechRecConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (config instanceof PortableServiceCommand) {
            this.myRecord = ((PortableSpeechRecConfig)config).getRecord();
            return;
        }
        this.setRecord(config.getSpeechRecServiceId(), config.getConfigSourceId(), config.getTimestampMillisecUTC(), config.getVocabLocation());
    }

    public PortableSpeechRecConfig(String speechRecServiceId, String configSourceId, long timestampMillisecUTC, String vocabLocation) {
        this.setRecord(speechRecServiceId, configSourceId, timestampMillisecUTC, vocabLocation);
    }

    private void setRecord(String speechRecServiceId, String configSourceId, long timestampMillisecUTC, String vocabLocation) {
        if (speechRecServiceId == null || configSourceId == null || vocabLocation == null) {
            throw new NullPointerException();
        }
        this.myRecord = new SpeechRecConfigRecord();
        this.myRecord.speechRecServiceId = new Utf8(speechRecServiceId);
        this.myRecord.configSourceId = new Utf8(configSourceId);
        this.myRecord.timestampMillisecUTC = timestampMillisecUTC;
        this.myRecord.vocabLocation = new Utf8(vocabLocation);
    }

    public String getSpeechRecServiceId() {
        return this.myRecord.speechRecServiceId.toString();
    }

    public String getConfigSourceId() {
        return this.myRecord.configSourceId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public String getVocabLocation() {
        return this.myRecord.vocabLocation.toString();
    }

    public SpeechRecConfigRecord getRecord() {
        return this.myRecord;
    }

    public static class Factory
    implements SpeechRecConfigFactory {
        public SpeechRecConfig create(String speechRecServiceId, String configSourceId, String vocabLocation) {
            return new PortableSpeechRecConfig(speechRecServiceId, configSourceId, TimeUtils.now(), vocabLocation);
        }
    }

    public static class RecordMessageAdapter
    implements Adapter<SpeechRecConfigRecord, SpeechRecConfig> {
        public SpeechRecConfig adapt(SpeechRecConfigRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRecConfig(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<SpeechRecConfig, SpeechRecConfigRecord> {
        public SpeechRecConfigRecord adapt(SpeechRecConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableSpeechRecConfig(a).getRecord();
        }
    }
}

