/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.impl.vision;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.vision.ImageEvent;
import org.robokind.api.vision.ImageService;
import org.robokind.avrogen.vision.ImageRecord;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;

/**
 * JMSAvroMessageAsyncReceiver for receiving ImageEvents.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSImageReceiver extends 
        JMSAvroMessageAsyncReceiver<ImageEvent, ImageRecord> implements 
        ImageService {
    /**
     * Creates a new JMSImageReceiver.
     * @param session JMS Session to use for receiving
     * @param destination JMS Destination to receive from
     */
    public JMSImageReceiver(Session session, Destination destination){
        super(session, destination, ImageRecord.class, ImageRecord.SCHEMA$);
        setAdapter(new PortableImageEvent.ImageRecordAdapter());
    }
}
