/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.impl.vision;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.vision.ImageRegionService;
import org.robokind.api.vision.ImageRegionList;
import org.robokind.avrogen.vision.ImageRegionListRecord;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;

/**
 * JMSAvroMessageAsyncReceiver for receiving ImageRegionLists.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSImageRegionListReceiver extends 
        JMSAvroMessageAsyncReceiver<ImageRegionList, ImageRegionListRecord> 
        implements ImageRegionService{
    /**
     * Creates a new JMSImageRegionListReceiver.
     * @param session JMS Session to use for receiving
     * @param destination JMS Destination to receive from
     */
    public JMSImageRegionListReceiver(Session session, Destination destination){
        super(session, destination, 
                ImageRegionListRecord.class, 
                ImageRegionListRecord.SCHEMA$);
        setAdapter(new PortableImageRegionList.ImageRegionListRecordAdapter());
    }
}
