/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import java.awt.Image;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.vision.ImageEvent;
import org.robokind.avrogen.vision.ImageRecord;
import org.robokind.impl.vision.PortableImageUtils;

public class PortableImageEvent
implements ImageEvent {
    private ImageRecord myImageRecord;
    private Image myCachedImage;

    public PortableImageEvent(ImageRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myImageRecord = record;
    }

    public Image getImage() {
        if (this.myCachedImage == null) {
            this.myCachedImage = PortableImageUtils.unpackImage(this.myImageRecord);
        }
        return this.myCachedImage;
    }

    public ImageRecord getImageRecord() {
        return this.myImageRecord;
    }

    public String getImageSourceId() {
        return this.myImageRecord.imageSourceId.toString();
    }

    public long getImageTimestampUTC() {
        return this.myImageRecord.imageTimestampMillisecUTC;
    }

    public long getImageId() {
        return this.myImageRecord.imageId;
    }

    public int getWidth() {
        return this.myImageRecord.width;
    }

    public int getHeight() {
        return this.myImageRecord.height;
    }

    public int getChannelCount() {
        return this.myImageRecord.nChannels;
    }

    public int getWidthStep() {
        return this.myImageRecord.widthStep;
    }

    public static class ImageRecordAdapter
    implements Adapter<ImageRecord, ImageEvent> {
        public ImageEvent adapt(ImageRecord a) {
            return new PortableImageEvent(a);
        }
    }
}

