/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.vision;

import org.robokind.api.vision.ImageRegion;
import org.robokind.avrogen.vision.ImageRegionRecord;

/**
 * ImageRegion implementation wrapping an ImageRegionRecord.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableImageRegion implements ImageRegion{
    private ImageRegionRecord myImageRegionRecord;

    /**
     * Creates a new PortableImageRegion.
     * @param region ImageRegionRecord to wrap
     */
    public PortableImageRegion(ImageRegionRecord region){
        if(region == null){
            throw new NullPointerException();
        }
        myImageRegionRecord = region;
    }

    @Override
    public long getRegionId() {
        return myImageRegionRecord.regionId;
    }

    @Override
    public int getX() {
        return myImageRegionRecord.x;
    }

    @Override
    public int getY() {
        return myImageRegionRecord.y;
    }

    @Override
    public int getWidth() {
        return myImageRegionRecord.width;
    }

    @Override
    public int getHeight() {
        return myImageRegionRecord.height;
    }

    /**
     * Returns the underlying ImageRegionRecord.
     * @return underlying ImageRegionRecord
     */
    public ImageRegionRecord getImageRegionRecord(){
        return myImageRegionRecord;
    } 
}
