/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.vision.config.CameraServiceConfig;
import org.robokind.avrogen.vision.CameraConfig;

public class PortableCameraServiceConfig
implements CameraServiceConfig {
    private CameraConfig myRecord;

    public PortableCameraServiceConfig(CameraConfig record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableCameraServiceConfig(CameraServiceConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.setRecord(config.getConfigSourceId(), config.getCameraServiceId(), config.getCameraNumber(), config.getFrameLength(), config.getImageWidth(), config.getImageHeight(), config.getImageChannels());
    }

    public PortableCameraServiceConfig(String sourceId, String imageServiceId, int cameraNumber, int frameLength, int imageWidth, int imageHeight, int imageChannels) {
        this.setRecord(sourceId, imageServiceId, cameraNumber, frameLength, imageWidth, imageHeight, imageChannels);
    }

    private void setRecord(String sourceId, String imageServiceId, int cameraNumber, int frameLength, int imageWidth, int imageHeight, int imageChannels) {
        this.myRecord = new CameraConfig();
        this.myRecord.brokerAddress = new Utf8("");
        this.myRecord.connectionOptions = new Utf8("");
        this.myRecord.destination = new Utf8("");
        this.myRecord.cameraNumber = cameraNumber;
        this.myRecord.frameLength = frameLength;
        this.myRecord.imageWidth = imageWidth;
        this.myRecord.imageHeight = imageHeight;
        this.myRecord.imageChannels = imageChannels;
    }

    public String getConfigSourceId() {
        return this.myRecord.destination.toString();
    }

    public String getCameraServiceId() {
        return this.myRecord.destination.toString();
    }

    public int getCameraNumber() {
        return this.myRecord.cameraNumber;
    }

    public int getFrameLength() {
        return this.myRecord.frameLength;
    }

    public int getImageWidth() {
        return this.myRecord.imageWidth;
    }

    public int getImageHeight() {
        return this.myRecord.imageHeight;
    }

    public int getImageChannels() {
        return this.myRecord.imageChannels;
    }

    public CameraConfig getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<CameraConfig, CameraServiceConfig> {
        public CameraServiceConfig adapt(CameraConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableCameraServiceConfig(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<CameraServiceConfig, CameraConfig> {
        public CameraConfig adapt(CameraServiceConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableCameraServiceConfig(a).getRecord();
        }
    }
}

