/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.vision.config.FaceDetectServiceConfig;
import org.robokind.avrogen.vision.FaceDetectConfig;

public class PortableFaceDetectServiceConfig
implements FaceDetectServiceConfig {
    private FaceDetectConfig myRecord;

    public PortableFaceDetectServiceConfig(FaceDetectConfig record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableFaceDetectServiceConfig(FaceDetectServiceConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.setRecord(config.getConfigSourceId(), config.getFaceDetectServiceId(), config.getHaarFileLocation(), config.getScaleFactor(), config.getNeighbors(), config.getHaarFlags(), config.getMinFaceWidth(), config.getMinFaceHeight());
    }

    public PortableFaceDetectServiceConfig(String sourceId, String faceDetectServiceId, String haarLocation, double scaleFactor, int neighbors, int haarFlags, int minFaceWidth, int minFaceHeight) {
        this.setRecord(sourceId, faceDetectServiceId, haarLocation, scaleFactor, neighbors, haarFlags, minFaceWidth, minFaceHeight);
    }

    private void setRecord(String sourceId, String faceDetectServiceId, String haarLocation, double scaleFactor, int neighbors, int haarFlags, int minFaceWidth, int minFaceHeight) {
        this.myRecord = new FaceDetectConfig();
        this.myRecord.brokerAddress = new Utf8("");
        this.myRecord.connectionOptions = new Utf8("");
        this.myRecord.haarFileLocation = new Utf8(haarLocation);
        this.myRecord.haarFlags = haarFlags;
        this.myRecord.minFaceHeight = minFaceHeight;
        this.myRecord.minFaceWidth = minFaceWidth;
        this.myRecord.neighbors = neighbors;
        this.myRecord.receivingAddress = new Utf8("");
        this.myRecord.resultsAddress = new Utf8("");
        this.myRecord.scaleFactor = scaleFactor;
    }

    public String getConfigSourceId() {
        return this.myRecord.resultsAddress.toString();
    }

    public String getFaceDetectServiceId() {
        return this.myRecord.resultsAddress.toString();
    }

    public String getHaarFileLocation() {
        return this.myRecord.haarFileLocation.toString();
    }

    public double getScaleFactor() {
        return this.myRecord.scaleFactor;
    }

    public int getNeighbors() {
        return this.myRecord.neighbors;
    }

    public int getHaarFlags() {
        return this.myRecord.haarFlags;
    }

    public int getMinFaceWidth() {
        return this.myRecord.minFaceWidth;
    }

    public int getMinFaceHeight() {
        return this.myRecord.minFaceHeight;
    }

    public FaceDetectConfig getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<FaceDetectConfig, FaceDetectServiceConfig> {
        public FaceDetectServiceConfig adapt(FaceDetectConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableFaceDetectServiceConfig(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<FaceDetectServiceConfig, FaceDetectConfig> {
        public FaceDetectConfig adapt(FaceDetectServiceConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableFaceDetectServiceConfig(a).getRecord();
        }
    }
}

