/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import java.awt.Image;
import java.nio.ByteBuffer;
import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.vision.ImageEvent;
import org.robokind.avrogen.vision.ImageRecord;
import org.robokind.impl.vision.PortableImageUtils;

public class PortableImageEvent
implements ImageEvent {
    private ImageRecord myImageRecord;
    private Image myCachedImage;

    public PortableImageEvent(ImageRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myImageRecord = record;
    }

    public Image getImage() {
        if (this.myCachedImage == null) {
            this.myCachedImage = PortableImageUtils.unpackImage(this.myImageRecord);
        }
        return this.myCachedImage;
    }

    public ImageRecord getImageRecord() {
        return this.myImageRecord;
    }

    public String getImageSourceId() {
        return this.myImageRecord.imageSourceId.toString();
    }

    public long getImageTimestampUTC() {
        return this.myImageRecord.imageTimestampMillisecUTC;
    }

    public long getImageId() {
        return this.myImageRecord.imageId;
    }

    public int getWidth() {
        return this.myImageRecord.width;
    }

    public int getHeight() {
        return this.myImageRecord.height;
    }

    public int getChannelCount() {
        return this.myImageRecord.nChannels;
    }

    public int getWidthStep() {
        return this.myImageRecord.widthStep;
    }

    public ByteBuffer getImageData() {
        return this.myImageRecord.data;
    }

    public static class MessageRecordAdapter
    implements Adapter<ImageEvent, ImageRecord> {
        public ImageRecord adapt(ImageEvent a) {
            ImageRecord rec = new ImageRecord();
            rec.data = a.getImageData();
            rec.height = a.getHeight();
            rec.imageId = a.getImageId();
            rec.imageSourceId = new Utf8(a.getImageSourceId());
            rec.imageTimestampMillisecUTC = a.getImageTimestampUTC();
            rec.nChannels = a.getChannelCount();
            rec.width = a.getWidth();
            rec.widthStep = a.getWidthStep();
            return rec;
        }
    }

    public static class RecordMessageAdapter
    implements Adapter<ImageRecord, ImageEvent> {
        public ImageEvent adapt(ImageRecord a) {
            return new PortableImageEvent(a);
        }
    }
}

