/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.vision;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.vision.config.CameraServiceConfig;
import org.robokind.avrogen.vision.CameraConfig;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class PortableCameraServiceConfig implements CameraServiceConfig{
    private CameraConfig myRecord;
    
    public PortableCameraServiceConfig(CameraConfig record){
        if(record == null){
            throw new NullPointerException();
        }
        myRecord = record;
    }
    
    public PortableCameraServiceConfig(CameraServiceConfig config){
        if(config == null){
            throw new NullPointerException();
        }
        setRecord(config.getConfigSourceId(), config.getCameraServiceId(), 
                config.getCameraNumber(), config.getFrameLength(),
                config.getImageWidth(), config.getImageHeight(),
                config.getImageChannels(), config.getCameraWidth(),
                config.getCameraHeight(), config.getCameraChannels(),
                config.getFlipImage());
    }
    
    public PortableCameraServiceConfig(String sourceId, 
            String imageServiceId, int cameraNumber, int frameLength, 
            int imageWidth, int imageHeight, int imageChannels, 
            int cameraWidth, int cameraHeight, int cameraChannels,
            boolean flipImage){
        setRecord(sourceId, imageServiceId, cameraNumber, 
                frameLength, imageWidth, imageHeight, imageChannels, 
                cameraWidth, cameraHeight, cameraChannels, flipImage);
    }
    
    private void setRecord(String sourceId, 
            String imageServiceId, int cameraNumber, int frameLength, 
            int imageWidth, int imageHeight, int imageChannels, 
            int cameraWidth, int cameraHeight, int cameraChannels,
            boolean flipImage){
        myRecord = new CameraConfig();
        myRecord.brokerAddress = new Utf8("");
        myRecord.connectionOptions = new Utf8("");
        myRecord.destination = new Utf8("");
        myRecord.cameraNumber = cameraNumber;
        myRecord.frameLength = frameLength;
        myRecord.imageWidth = imageWidth;
        myRecord.imageHeight = imageHeight;
        myRecord.imageChannels = imageChannels;
        myRecord.cameraWidth = cameraWidth;
        myRecord.cameraHeight = cameraHeight;
        myRecord.cameraChannels = cameraChannels;
        myRecord.flipImage = flipImage;
    }

    @Override
    public String getConfigSourceId() {
        return myRecord.destination.toString();
    }

    @Override
    public String getCameraServiceId() {
        return myRecord.destination.toString();
    }

    @Override
    public int getCameraNumber() {
        return myRecord.cameraNumber;
    }

    @Override
    public int getFrameLength() {
        return myRecord.frameLength;
    }

    @Override
    public int getImageWidth() {
        return myRecord.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return myRecord.imageHeight;
    }

    @Override
    public int getImageChannels() {
        return myRecord.imageChannels;
    }

    @Override
    public int getCameraWidth() {
        return myRecord.cameraWidth;
    }

    @Override
    public int getCameraHeight() {
        return myRecord.cameraHeight;
    }

    @Override
    public int getCameraChannels() {
        return myRecord.cameraChannels;
    }

    @Override
    public boolean getFlipImage() {
        return myRecord.flipImage;
    }
    
    public CameraConfig getRecord(){
        return myRecord;
    }
    
    public static class MessageRecordAdapter implements 
            Adapter<CameraServiceConfig,CameraConfig>{

        @Override
        public CameraConfig adapt(CameraServiceConfig a) {
            if(a == null){
                throw new NullPointerException();
            }
            return new PortableCameraServiceConfig(a).getRecord();
        }
    }
    
    public static class RecordMessageAdapter implements
            Adapter<CameraConfig, CameraServiceConfig>{

        @Override
        public CameraServiceConfig adapt(CameraConfig a) {
            if(a == null){
                throw new NullPointerException();
            }
            return new PortableCameraServiceConfig(a);
        }
    }
}
