/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.vision.config.CameraServiceConfig;
import org.robokind.avrogen.vision.CameraConfig;

public class PortableCameraServiceConfig
implements CameraServiceConfig {
    private CameraConfig myRecord;

    public PortableCameraServiceConfig(CameraConfig record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableCameraServiceConfig(CameraServiceConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.setRecord(config.getConfigSourceId(), config.getCameraServiceId(), config.getCameraNumber(), config.getFrameLength(), config.getImageWidth(), config.getImageHeight(), config.getImageChannels(), config.getCameraWidth(), config.getCameraHeight(), config.getCameraChannels(), config.getFlipImage());
    }

    public PortableCameraServiceConfig(String sourceId, String imageServiceId, int cameraNumber, int frameLength, int imageWidth, int imageHeight, int imageChannels, int cameraWidth, int cameraHeight, int cameraChannels, boolean flipImage) {
        this.setRecord(sourceId, imageServiceId, cameraNumber, frameLength, imageWidth, imageHeight, imageChannels, cameraWidth, cameraHeight, cameraChannels, flipImage);
    }

    private void setRecord(String sourceId, String imageServiceId, int cameraNumber, int frameLength, int imageWidth, int imageHeight, int imageChannels, int cameraWidth, int cameraHeight, int cameraChannels, boolean flipImage) {
        this.myRecord = new CameraConfig();
        this.myRecord.brokerAddress = new Utf8("");
        this.myRecord.connectionOptions = new Utf8("");
        this.myRecord.destination = new Utf8("");
        this.myRecord.cameraNumber = cameraNumber;
        this.myRecord.frameLength = frameLength;
        this.myRecord.imageWidth = imageWidth;
        this.myRecord.imageHeight = imageHeight;
        this.myRecord.imageChannels = imageChannels;
        this.myRecord.cameraWidth = cameraWidth;
        this.myRecord.cameraHeight = cameraHeight;
        this.myRecord.cameraChannels = cameraChannels;
        this.myRecord.flipImage = flipImage;
    }

    public String getConfigSourceId() {
        return this.myRecord.destination.toString();
    }

    public String getCameraServiceId() {
        return this.myRecord.destination.toString();
    }

    public int getCameraNumber() {
        return this.myRecord.cameraNumber;
    }

    public int getFrameLength() {
        return this.myRecord.frameLength;
    }

    public int getImageWidth() {
        return this.myRecord.imageWidth;
    }

    public int getImageHeight() {
        return this.myRecord.imageHeight;
    }

    public int getImageChannels() {
        return this.myRecord.imageChannels;
    }

    public int getCameraWidth() {
        return this.myRecord.cameraWidth;
    }

    public int getCameraHeight() {
        return this.myRecord.cameraHeight;
    }

    public int getCameraChannels() {
        return this.myRecord.cameraChannels;
    }

    public boolean getFlipImage() {
        return this.myRecord.flipImage;
    }

    public CameraConfig getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<CameraConfig, CameraServiceConfig> {
        public CameraServiceConfig adapt(CameraConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableCameraServiceConfig(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<CameraServiceConfig, CameraConfig> {
        public CameraConfig adapt(CameraServiceConfig a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableCameraServiceConfig(a).getRecord();
        }
    }
}

