/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import org.apache.avro.generic.GenericArray;
import org.jflux.api.core.Adapter;
import org.robokind.api.vision.ImageRegion;
import org.robokind.api.vision.ImageRegionList;
import org.robokind.avrogen.vision.ImageRegionListRecord;
import org.robokind.avrogen.vision.ImageRegionRecord;
import org.robokind.impl.vision.PortableImageRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableImageRegionList
implements ImageRegionList {
    private static final Logger theLogger = LoggerFactory.getLogger(PortableImageRegionList.class);
    private ImageRegionListRecord myImageRegionListRecord;
    private PortableImageRegion[] myRegionArray;

    public PortableImageRegionList(ImageRegionListRecord regions) {
        if (regions == null) {
            throw new NullPointerException();
        }
        this.myImageRegionListRecord = regions;
        GenericArray regionArr = regions.regions;
        if (regionArr == null) {
            this.myRegionArray = new PortableImageRegion[0];
        }
        int size = regionArr.size();
        this.myRegionArray = new PortableImageRegion[regionArr.size()];
        for (int i = 0; i < size; ++i) {
            try {
                ImageRegionRecord region = (ImageRegionRecord)regionArr.get(i);
                if (region == null) continue;
                this.myRegionArray[i] = new PortableImageRegion(region);
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                theLogger.warn("Index out of bounds.", (Throwable)ex);
            }
        }
    }

    public PortableImageRegionList(ImageRegionList regionList) {
        if (regionList == null) {
            throw new NullPointerException();
        }
        if (regionList instanceof PortableImageRegionList) {
            PortableImageRegionList plist = (PortableImageRegionList)regionList;
            this.myImageRegionListRecord = plist.myImageRegionListRecord;
            this.myRegionArray = plist.myRegionArray;
        }
    }

    public String getImageSourceId() {
        return this.myImageRegionListRecord.imageSourceId.toString();
    }

    public long getImageId() {
        return this.myImageRegionListRecord.imageId;
    }

    public long getImageTimestampUTC() {
        return this.myImageRegionListRecord.imageTimestampMillisecUTC;
    }

    public String getImageProcessorId() {
        return this.myImageRegionListRecord.imageProcessorId.toString();
    }

    public long getImageRegionsId() {
        return this.myImageRegionListRecord.imageRegionsId;
    }

    public long getProcessorStartTimestampUTC() {
        return this.myImageRegionListRecord.processorStartTimestampMillisecUTC;
    }

    public long getProcessorCompleteTimestampUTC() {
        return this.myImageRegionListRecord.processorCompleteTimestampMillisecUTC;
    }

    public ImageRegion[] getImageRegions() {
        return this.myRegionArray;
    }

    public ImageRegionListRecord getRecord() {
        return this.myImageRegionListRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<ImageRegionListRecord, ImageRegionList> {
        public ImageRegionList adapt(ImageRegionListRecord a) {
            return new PortableImageRegionList(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<ImageRegionList, ImageRegionListRecord> {
        public ImageRegionListRecord adapt(ImageRegionList a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableImageRegionList(a).getRecord();
        }
    }
}

