/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.vision;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.robokind.api.common.utils.Utils;
import org.robokind.avrogen.vision.ImageRecord;

public class PortableImageUtils {
    public static BufferedImage unpackImage(ImageRecord record) {
        int w = record.width;
        int h = record.height;
        int wStep = record.widthStep;
        int c = record.nChannels;
        ByteBuffer data = record.data;
        BufferedImage bimg = new BufferedImage(record.width, record.height, 2);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = PortableImageUtils.getARGB(data, y * wStep + x * c, c);
                bimg.setRGB(x, y, argb);
            }
        }
        return bimg;
    }

    private static int getARGB(ByteBuffer data, int offset, int channels) {
        int a = 255;
        if (channels > 3) {
            a = Utils.unsign((byte)data.get(offset));
            ++offset;
        }
        return a << 24 | PortableImageUtils.getRGB(data, offset, channels);
    }

    private static int getRGB(ByteBuffer data, int offset, int channels) {
        int rgb = 0;
        int val = 0;
        for (int i = 0; i < 3; ++i) {
            if (i < channels) {
                val = Utils.unsign((byte)data.get(offset + i));
            }
            int shift = (2 - i) * 8;
            rgb |= val << shift;
        }
        return rgb;
    }
}

