/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarhome.hsb.server;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.rockhopper.smarhome.hsb.server.HomeAssistantIntegration;
import org.rockhopper.smarhome.hsb.server.MqttConfig;
import org.rockhopper.smarhome.hsb.server.MqttPushClient;
import org.rockhopper.smarhome.hsb.server.SMS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClient;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class MqttHsbClient
implements MqttCallback,
DisposableBean {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean shutdownInProgress = false;
    @Autowired
    private MqttConfig mqttConfig;
    @Autowired
    private FreeMarkerConfigurer freeMarkerConfigurer;
    @Autowired
    private MqttPushClient mqttPushClient;
    @Autowired
    private RestClient haRestClient;
    @Value(value="${phone.responseNumber}")
    private String responseNumber;

    public void start() {
        new HomeAssistantIntegration(this.mqttPushClient, this.freeMarkerConfigurer).fulfill();
        this.mqttPushClient.setCallback((MqttCallback)this);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void stop() {
        this.shutdownInProgress = true;
        if (this.mqttPushClient != null) {
            this.mqttPushClient.close();
        }
    }

    public void connectionLost(Throwable cause) {
        if (!this.shutdownInProgress) {
            this.log.error("Disconnected ({}).", (Object)(cause != null ? cause.getMessage() : null), (Object)cause);
            try {
                this.mqttPushClient.reconnectMqttPushClient();
            }
            catch (Exception e) {
                this.log.error("Exception caught while trying to reconnect to MQTT Server", (Throwable)e);
            }
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.log.info("Receive message subject : " + topic);
        this.log.info("receive messages Qos : " + message.getQos());
        this.log.info("Receive message content : " + String.valueOf(message.getPayload()));
        this.log.info("Receive message as String : " + new String(message.getPayload()));
        if (message.getPayload() == null) {
            return;
        }
        if (topic.startsWith(this.mqttConfig.getHsbBaseTopic())) {
            String payload = new String();
            this.log.info("{}>>{}", (Object)topic, (Object)payload);
        } else if (topic.startsWith(this.mqttConfig.getSmsBaseTopic())) {
            String subTopic;
            switch (subTopic = StringUtils.removeStart((String)topic, (String)(this.mqttConfig.getSmsBaseTopic() + "/"))) {
                case "connected": {
                    this.log.info("{}>>{}", (Object)topic, (Object)message.getPayload());
                    break;
                }
                case "received": {
                    String payload = new String(message.getPayload());
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.registerModule((Module)new JavaTimeModule());
                    SMS sms = (SMS)objectMapper.readValue(payload, SMS.class);
                    ResponseEntity response = ((RestClient.RequestBodySpec)this.haRestClient.post().uri("https://ha.rockhopper.org/api/services/notify/mobile_app_rmx3472", new Object[0])).body((Object)"{\"message\": \"At %s from %s: %s\"}".formatted(DateTimeFormatter.ISO_LOCAL_TIME.format(sms.getDatetime()), sms.getNumber(), sms.getText())).retrieve().toBodilessEntity();
                    int responseCode = response.getStatusCode().value();
                    System.out.println(responseCode);
                    this.mqttPushClient.publishToTopic(0, false, "sms2mqtt/send", "{\"number\":\"%s\", \"text\":\"%s\"}".formatted(this.responseNumber, responseCode));
                    break;
                }
                case "signal": {
                    this.log.info("{}>>{}", (Object)topic, (Object)message.getPayload());
                    break;
                }
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.log.info("deliveryComplete---------" + token.isComplete());
    }

    public void destroy() throws Exception {
        this.log.info("MqttHsbClient#destroy() is stopping MQTT HSB Client!");
        if (!this.shutdownInProgress) {
            this.stop();
        }
    }
}

