/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarhome.hsb.server;

import jakarta.annotation.PostConstruct;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.rockhopper.smarhome.hsb.server.MqttConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class MqttPushClient {
    private static final Logger logger = LoggerFactory.getLogger(MqttPushClient.class);
    protected boolean shutdownInProgress = false;
    private static MqttClient client;
    @Autowired
    private MqttConfig mqttConfig;
    private String statTopic;

    private MqttClient getClient() {
        return client;
    }

    private static void setClient(MqttClient client) {
        MqttPushClient.client = client;
    }

    public void connect(String host, String clientID, String username, String password, String statTopic, int timeout, int keepalive) {
        if (this.shutdownInProgress) {
            return;
        }
        this.statTopic = statTopic;
        try {
            client = new MqttClient(host, clientID, (MqttClientPersistence)new MemoryPersistence());
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(true);
            options.setUserName(username);
            options.setPassword(password.toCharArray());
            options.setConnectionTimeout(timeout);
            options.setKeepAliveInterval(keepalive);
            MqttPushClient.setClient((MqttClient)client);
            try {
                client.connect(options);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.shutdownInProgress = true;
        if (client != null) {
            try {
                if (client.isConnected()) {
                    client.disconnectForcibly();
                }
                client.close();
            }
            catch (MqttException me) {
                logger.warn("Exception caught while closing (MQTT) Client", (Throwable)me);
            }
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        client.setCallback(mqttCallback);
    }

    public void publishToTopic(int qos, boolean retained, String topic, String pushMessage) {
        if (this.shutdownInProgress) {
            return;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(qos);
        message.setRetained(retained);
        message.setPayload(pushMessage.getBytes());
        MqttTopic mTopic = this.getClient().getTopic(topic);
        if (null == mTopic) {
            logger.error("topic not exist");
        }
        try {
            MqttDeliveryToken token = mTopic.publish(message);
            token.waitForCompletion();
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void publishToSubTopic(int qos, boolean retained, String subtopic, String pushMessage) {
        this.publishToTopic(qos, retained, this.statTopic + "/" + subtopic, pushMessage);
    }

    public void subscribe(String commandtopic, int qos) {
        logger.info("Start subscribing to topics {}", (Object)commandtopic);
        try {
            this.getClient().subscribe(commandtopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void reconnectMqttPushClient() {
        System.out.println("hostUrl: " + this.mqttConfig.getHostUrl());
        System.out.println("clientID: " + this.mqttConfig.getClientId());
        System.out.println("username: " + this.mqttConfig.getUsername());
        System.out.println("password: " + this.mqttConfig.getPassword());
        System.out.println("timeout: " + this.mqttConfig.getTimeout());
        System.out.println("keepalive: " + this.mqttConfig.getKeepalive());
        this.connect(this.mqttConfig.getHostUrl(), this.mqttConfig.getClientId(), this.mqttConfig.getUsername(), this.mqttConfig.getPassword(), this.mqttConfig.getHsbBaseTopic() + "/" + this.mqttConfig.getStatSubTopic(), this.mqttConfig.getTimeout(), this.mqttConfig.getKeepalive());
        this.subscribe(this.mqttConfig.getHsbBaseTopic() + "/" + this.mqttConfig.getCommandSubTopic() + "/#", 0);
        this.subscribe(this.mqttConfig.getSmsBaseTopic() + "/#", 0);
    }

    @PostConstruct
    public void init() {
        this.reconnectMqttPushClient();
    }
}

