/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarhome.hsb.server;

import org.rockhopper.smarhome.hsb.server.HaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClient;

@RestController
@RequestMapping(value={"/"})
public class ProxyController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HaConfig haConfig;
    @Autowired
    private RestClient haRestClient;
    @Value(value="${gretings.suffix:default}")
    private String suffixGreetingsMsg;

    @GetMapping(value={"/"})
    public String index() {
        return "Greetings from HSB! " + this.suffixGreetingsMsg;
    }

    @GetMapping(value={"/proxycmd/{key}"})
    public String publishTopic(@PathVariable(value="key") String key) {
        boolean success = false;
        switch (key) {
            case "momentary_parking_somfy_reflex": {
                success = this.switchProxiedCommand(key);
                break;
            }
            default: {
                this.logger.info("No proxied command named '{}'", (Object)key);
            }
        }
        return success ? "Success!" : "Failure!";
    }

    private boolean switchProxiedCommand(String switchEntityId) {
        ResponseEntity response = ((RestClient.RequestBodySpec)this.haRestClient.post().uri("%s://%s:%s/api/services/switch/turn_on".formatted(this.haConfig.getProtocol(), this.haConfig.getHost(), this.haConfig.getPort()), new Object[0])).body((Object)"{\"entity_id\": \"switch.%s\"}".formatted(switchEntityId)).retrieve().toBodilessEntity();
        int responseCode = response.getStatusCode().value();
        return responseCode == 200;
    }
}

