/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.simulator;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.rockhopper.smarthome.wes.jwes.simulator.config.NettyProperties;
import org.rockhopper.smarthome.wes.jwes.simulator.netty.TCPServer;
import org.rockhopper.smarthome.wes.jwes.simulator.netty.handler.TcpChannelInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
@EnableConfigurationProperties(value={NettyProperties.class})
public class Application
extends SpringBootServletInitializer {
    @Autowired
    private NettyProperties nettyProperties;
    @Autowired
    private TcpChannelInitializer tcpChannelInitializer;

    public static void main(String[] args) throws Exception {
        ConfigurableApplicationContext context = SpringApplication.run(Application.class, (String[])args);
        TCPServer tcpServer = (TCPServer)context.getBean(TCPServer.class);
        tcpServer.start();
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class});
    }

    @Bean(name={"tcpServerBootstrap"})
    public ServerBootstrap tcpServerBootstrap() {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup(), (EventLoopGroup)this.workerGroup()).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)this.tcpChannelInitializer);
        Map tcpChannelOptions = this.tcpChannelOptions();
        Set keySet = tcpChannelOptions.keySet();
        for (ChannelOption option : keySet) {
            b.option(option, tcpChannelOptions.get(option));
        }
        return b;
    }

    @Bean
    public Map<ChannelOption<?>, Object> tcpChannelOptions() {
        HashMap options = new HashMap();
        options.put(ChannelOption.SO_BACKLOG, this.nettyProperties.getBacklog());
        return options;
    }

    @Bean(destroyMethod="shutdownGracefully")
    public NioEventLoopGroup bossGroup() {
        return new NioEventLoopGroup(this.nettyProperties.getBossCount());
    }

    @Bean(destroyMethod="shutdownGracefully")
    public NioEventLoopGroup workerGroup() {
        return new NioEventLoopGroup(this.nettyProperties.getWorkerCount());
    }

    @Bean
    public InetSocketAddress tcpSocketAddress() {
        return new InetSocketAddress(this.nettyProperties.getTcpPort());
    }
}

