/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.simulator.catalina;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        response.addHeader("WWW-Authenticate", "Basic realm=" + this.getRealmName());
        response.setStatus(401);
        PrintWriter writer = response.getWriter();
        writer.println("HTTP Status 401 - " + authException.getMessage());
    }

    public void afterPropertiesSet() {
        this.setRealmName("\"serveur WES\"");
        super.afterPropertiesSet();
    }
}

