/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.simulator.netty.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="tcpChannelInitializer")
public class TcpChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final StringDecoder DECODER = new StringDecoder();
    private static final StringEncoder ENCODER = new StringEncoder();
    @Autowired
    @Qualifier(value="tcpServerHandler")
    private ChannelInboundHandlerAdapter tcpServerHandler;

    protected void initChannel(SocketChannel socketChannel) {
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(30));
        pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(0x100000, Delimiters.lineDelimiter())});
        pipeline.addLast(new ChannelHandler[]{DECODER});
        pipeline.addLast(new ChannelHandler[]{ENCODER});
        pipeline.addLast(new ChannelHandler[]{this.tcpServerHandler});
    }
}

