/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.simulator.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import jakarta.annotation.PreDestroy;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TCPServer {
    @Autowired
    @Qualifier(value="tcpServerBootstrap")
    private final ServerBootstrap serverBootstrap;
    @Autowired
    @Qualifier(value="tcpSocketAddress")
    private final InetSocketAddress tcpPort;
    private Channel serverChannel;

    @Autowired
    public TCPServer(@Qualifier(value="tcpServerBootstrap") ServerBootstrap serverBootstrap, @Qualifier(value="tcpSocketAddress") InetSocketAddress tcpPort) {
        this.serverBootstrap = serverBootstrap;
        this.tcpPort = tcpPort;
    }

    public void start() throws Exception {
        this.serverChannel = this.serverBootstrap.bind((SocketAddress)this.tcpPort).sync().channel().closeFuture().sync().channel();
    }

    @PreDestroy
    public void stop() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel.parent().close();
        }
    }
}

