/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.simulator.netty.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@ChannelHandler.Sharable
public class TcpServerHandler
extends ChannelInboundHandlerAdapter {
    private Logger log = LoggerFactory.getLogger((String)this.getClass().getName());

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(ctx.channel().remoteAddress()));
        }
        String channelKey = ctx.channel().remoteAddress().toString();
        this.log.info("Channel key is " + channelKey + "\r\n");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        String stringMessage = (String)msg;
        if (this.log.isDebugEnabled()) {
            this.log.debug(stringMessage);
        }
        if ("gI000".equals(stringMessage)) {
            ctx.channel().writeAndFlush((Object)"0011223344AA\n\r");
        } else {
            ctx.channel().writeAndFlush((Object)"???\n\r");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ReadTimeoutException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(ctx.channel().remoteAddress()) + " has been disconnected due to inactivity!");
            }
        } else {
            this.log.error(cause.getMessage(), cause);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Assert.notNull((Object)ctx, (String)"[Assertion failed] - ChannelHandlerContext is required; it must not be null");
    }
}

