/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String host;
    private FTPClient ftp;
    private boolean logged;

    public FtpClient(String host) {
        this.host = host;
        this.ftp = new FTPClient();
    }

    public boolean login(String username, String password) {
        FTPClientConfig config = new FTPClientConfig("WINDOWS");
        this.ftp.configure(config);
        try {
            this.ftp.connect(this.host);
            this.logger.info("(FTP) Connected to {}.", (Object)this.host);
            this.logger.debug(this.ftp.getReplyString());
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.disconnect(true);
            } else {
                this.ftp.enterLocalPassiveMode();
                if (this.ftp.login(username, password)) {
                    this.logged = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Exception caught while FTP login", (Throwable)e);
            this.disconnect(false);
        }
        return this.logged;
    }

    public void logout() {
        if (this.logged) {
            try {
                this.ftp.logout();
            }
            catch (IOException iOException) {
            }
            finally {
                this.disconnect(false);
            }
        }
    }

    public String printWorkingDirectory() throws IOException {
        if (this.logged) {
            return this.ftp.printWorkingDirectory();
        }
        return null;
    }

    public boolean changeWorkingDirectory(String pathname) throws IOException {
        if (this.logged && pathname != null) {
            return this.ftp.changeWorkingDirectory(pathname);
        }
        return false;
    }

    public boolean removeDirectory(String pathname) throws IOException {
        if (this.logged && pathname != null) {
            return this.ftp.removeDirectory(pathname);
        }
        return false;
    }

    public void deleteFiles(boolean force) throws IOException {
        Object workingDir = this.printWorkingDirectory();
        if (workingDir == null) {
            return;
        }
        if (!((String)workingDir).endsWith("/")) {
            workingDir = (String)workingDir + "/";
        }
        if (!force && "/".equals(workingDir)) {
            throw new IllegalArgumentException("FtpClient#deleteFiles(boolean false): Cannot delete all files from root folder without flag 'force' set!");
        }
        FTPFile[] ftpFiles = this.listFiles();
        if (ftpFiles != null && ftpFiles.length > 0) {
            for (FTPFile ftpFile : ftpFiles) {
                if (ftpFile == null) continue;
                String pathname = (String)workingDir + ftpFile.getName();
                this.logger.debug("Deleting: [{}]", (Object)pathname);
                this.ftp.deleteFile(pathname);
            }
        }
    }

    public FTPFile[] listFiles() throws IOException {
        if (this.logged) {
            return this.ftp.listFiles(null, new FTPFileFilter(this){

                public boolean accept(FTPFile file) {
                    return file != null && file.isFile();
                }
            });
        }
        return null;
    }

    public boolean makeDirectory(String pathname) throws IOException {
        if (this.logged && pathname != null) {
            return this.ftp.makeDirectory(pathname);
        }
        return false;
    }

    public boolean uploadClassPathFile(String remote, String classpathLocal) throws IOException {
        if (this.logged && remote != null) {
            try (InputStream local = this.getClass().getClassLoader().getResourceAsStream(classpathLocal);){
                boolean bl = this.ftp.storeFile(remote, local);
                return bl;
            }
        }
        return false;
    }

    public boolean uploadFile(String remote, InputStream local) throws IOException {
        if (this.logged && remote != null) {
            return this.ftp.storeFile(remote, local);
        }
        return false;
    }

    private boolean disconnect(boolean forceDisconnect) {
        boolean error = false;
        if (forceDisconnect || this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
            }
            catch (IOException ioe) {
                error = true;
            }
        }
        return !error;
    }
}

