/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class TcpClient {
    public static final long DEFAULT_SLEEP_TIME = 500L;
    private long sleepTime = 500L;
    private String host;
    private int port;
    private Socket socket;
    PrintWriter socketOut;
    BufferedReader socketIn;
    private ScheduledExecutorService executor;
    private Semaphore tcpPortSemaphore;

    public TcpClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.tcpPortSemaphore = new Semaphore(1);
        this.executor = Executors.newScheduledThreadPool(1);
    }

    public String call(String command) {
        String response;
        block12: {
            response = null;
            try {
                if (this.tcpPortSemaphore.tryAcquire(this.sleepTime, TimeUnit.MILLISECONDS)) {
                    if (this.socket == null) {
                        try {
                            this.socket = new Socket(this.host, this.port);
                            this.socketOut = new PrintWriter(this.socket.getOutputStream(), true);
                            this.socketIn = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.socket != null) {
                        try {
                            this.socketOut.println(command);
                            response = this.socketIn.readLine();
                            if (response != null && !response.isEmpty() && command.equals(response)) {
                                System.out.println("Response (request echoed): " + response);
                                response = this.socketIn.readLine();
                                if (response != null && !response.isEmpty() && response.startsWith("=")) {
                                    response = StringUtils.substring((String)response, (int)1);
                                }
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            this.close();
                        }
                    }
                    this.tcpPortSemaphore.release();
                    break block12;
                }
                System.out.println("Fail to acquire socket resource!");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    public void close() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.tcpPortSemaphore.acquire();
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.tcpPortSemaphore.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

