/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WesHttpClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpClientContext context = HttpClientContext.create();
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private HttpHost targetHost;

    public WesHttpClient(String host, int port) {
        this.targetHost = new HttpHost(host, port, "http");
    }

    public void login(String username, String password) {
        if (username != null && password != null) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(this.targetHost, (AuthScheme)basicAuth);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)credentials);
            this.context.setCredentialsProvider((CredentialsProvider)credsProvider);
            this.context.setAuthCache((AuthCache)authCache);
        }
    }

    public synchronized void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String httpGet(String path) {
        if (this.httpClient == null) {
            return null;
        }
        String content = null;
        HttpGet httpGet = new HttpGet(path);
        try (CloseableHttpResponse response = this.httpClient.execute(this.targetHost, (HttpRequest)httpGet, (HttpContext)this.context);){
            this.logger.debug("StatusLine: {}", (Object)response.getStatusLine());
            HttpEntity entity = response.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8"));
            this.logger.trace(">----");
            this.logger.trace(content);
            this.logger.trace("<----");
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return content;
    }
}

